/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.AbstractNioChannelTest;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NetworkChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class NioSocketChannelTest
extends AbstractNioChannelTest<NioSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCloseReentrance() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            final LinkedBlockingQueue futures = new LinkedBlockingQueue();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childOption(ChannelOption.SO_SNDBUF, (Object)1024);
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)));
                    ctx.flush();
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)));
                    ctx.flush();
                }
            });
            SocketAddress address = sb.bind(0).sync().channel().localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            InputStream in = s.getInputStream();
            byte[] buf = new byte[8192];
            while (in.read(buf) != -1) {
                Thread.sleep(10L);
            }
            s.close();
            MatcherAssert.assertThat((Object)futures.size(), (Matcher)CoreMatchers.is((Object)3));
            ChannelFuture f1 = (ChannelFuture)futures.poll();
            ChannelFuture f2 = (ChannelFuture)futures.poll();
            ChannelFuture f3 = (ChannelFuture)futures.poll();
            MatcherAssert.assertThat((Object)f1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f2.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            MatcherAssert.assertThat((Object)f3.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f3.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f3.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAfterGatheredFlush() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(final ChannelHandlerContext ctx) throws Exception {
                    ctx.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{97}));
                    ChannelFuture f = ctx.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{98}));
                    f.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{99}));
                        }
                    });
                    ctx.flush();
                }
            });
            SocketAddress address = sb.bind(0).sync().channel().localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte[] buf = new byte[3];
            in.readFully(buf);
            MatcherAssert.assertThat((Object)new String(buf, CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"abc"));
            s.close();
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    @Test(timeout=3000L)
    public void testChannelReRegisterReadSameEventLoop() throws Exception {
        NioSocketChannelTest.testChannelReRegisterRead(true);
    }

    @Test(timeout=3000L)
    public void testChannelReRegisterReadDifferentEventLoop() throws Exception {
        NioSocketChannelTest.testChannelReRegisterRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testChannelReRegisterRead(boolean sameEventLoop) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(2);
        final CountDownLatch latch = new CountDownLatch(1);
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Channel sc = null;
        Channel cc = null;
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)b.group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>((EventLoopGroup)group, sameEventLoop){
                final /* synthetic */ EventLoopGroup val$group;
                final /* synthetic */ boolean val$sameEventLoop;
                {
                    this.val$group = eventLoopGroup;
                    this.val$sameEventLoop = bl;
                }

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
                            latch.countDown();
                        }

                        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
                            final EventLoop loop = val$group.next();
                            if (val$sameEventLoop) {
                                this.deregister(ctx, loop);
                            } else {
                                loop.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.deregister(ctx, loop);
                                    }
                                });
                            }
                        }

                        private void deregister(ChannelHandlerContext ctx, final EventLoop loop) {
                            ctx.deregister().addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture cf) {
                                    Channel channel = cf.channel();
                                    Assert.assertNotSame((Object)loop, (Object)channel.eventLoop());
                                    val$group.next().register(channel);
                                }
                            });
                        }
                    }});
                }
            });
            sc = b.bind(0).syncUninterruptibly().channel();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            cc = bootstrap.connect(sc.localAddress()).syncUninterruptibly().channel();
            cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes)).syncUninterruptibly();
            latch.await();
        }
        finally {
            if (cc != null) {
                cc.close();
            }
            if (sc != null) {
                sc.close();
            }
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testShutdownOutputAndClose() throws IOException {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        ServerSocket socket = new ServerSocket();
        socket.bind(new InetSocketAddress(0));
        Socket accepted = null;
        try {
            Bootstrap sb = new Bootstrap();
            ((Bootstrap)sb.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            sb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            SocketChannel channel = (SocketChannel)sb.connect(socket.getLocalSocketAddress()).syncUninterruptibly().channel();
            accepted = socket.accept();
            channel.shutdownOutput().syncUninterruptibly();
            channel.close().syncUninterruptibly();
        }
        finally {
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (IOException iOException) {}
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioSocketChannel newNioChannel() {
        return new NioSocketChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

