/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.nio.SelectedSelectionKeySet;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class SelectedSelectionKeySetTest {
    @Mock
    private SelectionKey mockKey;
    @Mock
    private SelectionKey mockKey2;
    @Mock
    private SelectionKey mockKey3;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void addElements() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        int expectedSize = 1000000;
        for (int i = 0; i < 1000000; ++i) {
            Assert.assertTrue((boolean)set.add(this.mockKey));
        }
        Assert.assertEquals((long)1000000L, (long)set.size());
        Assert.assertFalse((boolean)set.isEmpty());
    }

    @Test
    public void resetSet() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assert.assertTrue((boolean)set.add(this.mockKey));
        Assert.assertTrue((boolean)set.add(this.mockKey2));
        set.reset(1);
        Assert.assertSame((Object)this.mockKey, (Object)set.keys[0]);
        Assert.assertNull((Object)set.keys[1]);
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void iterator() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assert.assertTrue((boolean)set.add(this.mockKey));
        Assert.assertTrue((boolean)set.add(this.mockKey2));
        Iterator keys = set.iterator();
        Assert.assertTrue((boolean)keys.hasNext());
        Assert.assertSame((Object)this.mockKey, keys.next());
        Assert.assertTrue((boolean)keys.hasNext());
        Assert.assertSame((Object)this.mockKey2, keys.next());
        Assert.assertFalse((boolean)keys.hasNext());
        try {
            keys.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            keys.remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void contains() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assert.assertTrue((boolean)set.add(this.mockKey));
        Assert.assertTrue((boolean)set.add(this.mockKey2));
        Assert.assertFalse((boolean)set.contains((Object)this.mockKey));
        Assert.assertFalse((boolean)set.contains((Object)this.mockKey2));
        Assert.assertFalse((boolean)set.contains((Object)this.mockKey3));
    }

    @Test
    public void remove() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assert.assertTrue((boolean)set.add(this.mockKey));
        Assert.assertFalse((boolean)set.remove((Object)this.mockKey));
        Assert.assertFalse((boolean)set.remove((Object)this.mockKey2));
    }
}

