/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.CompleteChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CompleteChannelFutureTest {
    @Test(expected=NullPointerException.class)
    public void shouldDisallowNullChannel() {
        new CompleteChannelFutureImpl(null);
    }

    @Test
    public void shouldNotDoAnythingOnRemove() throws Exception {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        CompleteChannelFutureImpl future = new CompleteChannelFutureImpl(channel);
        ChannelFutureListener l = (ChannelFutureListener)Mockito.mock(ChannelFutureListener.class);
        future.removeListener((GenericFutureListener)l);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{l});
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
    }

    @Test
    public void testConstantProperties() throws InterruptedException {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        CompleteChannelFutureImpl future = new CompleteChannelFutureImpl(channel);
        Assert.assertSame((Object)channel, (Object)future.channel());
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertSame((Object)((Object)future), (Object)future.await());
        Assert.assertTrue((boolean)future.await(1L));
        Assert.assertTrue((boolean)future.await(1L, TimeUnit.NANOSECONDS));
        Assert.assertSame((Object)((Object)future), (Object)future.awaitUninterruptibly());
        Assert.assertTrue((boolean)future.awaitUninterruptibly(1L));
        Assert.assertTrue((boolean)future.awaitUninterruptibly(1L, TimeUnit.NANOSECONDS));
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
    }

    private static class CompleteChannelFutureImpl
    extends CompleteChannelFuture {
        CompleteChannelFutureImpl(Channel channel) {
            super(channel, null);
        }

        public Throwable cause() {
            throw new Error();
        }

        public boolean isSuccess() {
            throw new Error();
        }

        public ChannelFuture sync() throws InterruptedException {
            throw new Error();
        }

        public ChannelFuture syncUninterruptibly() {
            throw new Error();
        }
    }
}

