/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.AbstractEventLoopTest;
import io.netty.channel.Channel;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioTask;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.IntSupplier;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class NioEventLoopTest
extends AbstractEventLoopTest {
    @Override
    protected EventLoopGroup newEventLoopGroup() {
        return new NioEventLoopGroup();
    }

    @Override
    protected Class<? extends ServerSocketChannel> newChannel() {
        return NioServerSocketChannel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuildSelector() {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        final NioEventLoop loop = (NioEventLoop)group.next();
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel();
            loop.register((Channel)channel).syncUninterruptibly();
            Selector selector = loop.unwrappedSelector();
            Assert.assertSame((Object)selector, (Object)((NioEventLoop)channel.eventLoop()).unwrappedSelector());
            Assert.assertTrue((boolean)selector.isOpen());
            loop.submit(new Runnable(){

                @Override
                public void run() {
                    loop.rebuildSelector();
                }
            }).syncUninterruptibly();
            Selector newSelector = ((NioEventLoop)channel.eventLoop()).unwrappedSelector();
            Assert.assertTrue((boolean)newSelector.isOpen());
            Assert.assertNotSame((Object)selector, (Object)newSelector);
            Assert.assertFalse((boolean)selector.isOpen());
            channel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testScheduleBigDelayNotOverflow() {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        EventLoop el = group.next();
        ScheduledFuture future = el.schedule(new Runnable(){

            @Override
            public void run() {
            }
        }, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)future.awaitUninterruptibly(1000L));
        Assert.assertTrue((boolean)future.cancel(true));
        group.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptEventLoopThread() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        NioEventLoop loop = (NioEventLoop)group.next();
        try {
            Selector selector = loop.unwrappedSelector();
            Assert.assertTrue((boolean)selector.isOpen());
            loop.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().interrupt();
                }
            }).syncUninterruptibly();
            Assert.assertTrue((boolean)selector.isOpen());
            final CountDownLatch latch = new CountDownLatch(2);
            loop.submit(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            }).syncUninterruptibly();
            loop.schedule(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            }, 2L, TimeUnit.SECONDS).syncUninterruptibly();
            latch.await();
            Assert.assertSame((Object)selector, (Object)loop.unwrappedSelector());
            Assert.assertTrue((boolean)selector.isOpen());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testSelectableChannel() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        NioEventLoop loop = (NioEventLoop)group.next();
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel();
            loop.register((Channel)channel).syncUninterruptibly();
            channel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            SocketChannel selectableChannel = SocketChannel.open();
            selectableChannel.configureBlocking(false);
            selectableChannel.connect(channel.localAddress());
            final CountDownLatch latch = new CountDownLatch(1);
            loop.register((SelectableChannel)selectableChannel, 8, (NioTask)new NioTask<SocketChannel>(){

                public void channelReady(SocketChannel ch, SelectionKey key) {
                    latch.countDown();
                }

                public void channelUnregistered(SocketChannel ch, Throwable cause) {
                }
            });
            latch.await();
            selectableChannel.close();
            channel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testTaskRemovalOnShutdownThrowsNoUnsupportedOperationException() throws Exception {
        final AtomicReference error = new AtomicReference();
        final Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        for (int i = 0; i < 1000; ++i) {
            NioEventLoopGroup group = new NioEventLoopGroup(1);
            final NioEventLoop loop = (NioEventLoop)group.next();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            loop.execute(task);
                        }
                    }
                    catch (Throwable cause) {
                        error.set(cause);
                        return;
                    }
                }
            });
            t.start();
            group.shutdownNow();
            t.join();
            group.terminationFuture().syncUninterruptibly();
            Assert.assertThat(error.get(), (Matcher)IsInstanceOf.instanceOf(RejectedExecutionException.class));
            error.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuildSelectorOnIOException() {
        SelectStrategyFactory selectStrategyFactory = new SelectStrategyFactory(){

            public SelectStrategy newSelectStrategy() {
                return new SelectStrategy(){
                    private boolean thrown;

                    public int calculateStrategy(IntSupplier selectSupplier, boolean hasTasks) throws Exception {
                        if (!this.thrown) {
                            this.thrown = true;
                            throw new IOException();
                        }
                        return -1;
                    }
                };
            }
        };
        NioEventLoopGroup group = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("ioPool"), SelectorProvider.provider(), selectStrategyFactory);
        NioEventLoop loop = (NioEventLoop)group.next();
        try {
            NioServerSocketChannel channel = new NioServerSocketChannel();
            Selector selector = loop.unwrappedSelector();
            loop.register((Channel)channel).syncUninterruptibly();
            Selector newSelector = ((NioEventLoop)channel.eventLoop()).unwrappedSelector();
            Assert.assertTrue((boolean)newSelector.isOpen());
            Assert.assertNotSame((Object)selector, (Object)newSelector);
            Assert.assertFalse((boolean)selector.isOpen());
            channel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testChannelsRegistered() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        NioEventLoop loop = (NioEventLoop)group.next();
        try {
            int registered;
            NioServerSocketChannel ch1 = new NioServerSocketChannel();
            NioServerSocketChannel ch2 = new NioServerSocketChannel();
            Assert.assertEquals((long)0L, (long)NioEventLoopTest.registeredChannels((SingleThreadEventLoop)loop));
            Assert.assertTrue((boolean)loop.register((Channel)ch1).syncUninterruptibly().isSuccess());
            Assert.assertTrue((boolean)loop.register((Channel)ch2).syncUninterruptibly().isSuccess());
            Assert.assertEquals((long)2L, (long)NioEventLoopTest.registeredChannels((SingleThreadEventLoop)loop));
            Assert.assertTrue((boolean)ch1.deregister().syncUninterruptibly().isSuccess());
            while ((registered = NioEventLoopTest.registeredChannels((SingleThreadEventLoop)loop)) == 2) {
                Thread.sleep(50L);
            }
            Assert.assertEquals((long)1L, (long)registered);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static int registeredChannels(final SingleThreadEventLoop loop) throws Exception {
        return (Integer)loop.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return loop.registeredChannels();
            }
        }).get(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomQueue() {
        final AtomicBoolean called = new AtomicBoolean();
        NioEventLoopGroup group = new NioEventLoopGroup(1, (Executor)new ThreadPerTaskExecutor((ThreadFactory)new DefaultThreadFactory(NioEventLoopGroup.class)), (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), new EventLoopTaskQueueFactory(){

            public Queue<Runnable> newTaskQueue(int maxCapacity) {
                called.set(true);
                return new LinkedBlockingQueue<Runnable>(maxCapacity);
            }
        });
        NioEventLoop loop = (NioEventLoop)group.next();
        try {
            loop.submit(new Runnable(){

                @Override
                public void run() {
                }
            }).syncUninterruptibly();
            Assert.assertTrue((boolean)called.get());
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

