/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.CustomChannelId;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.embedded.EmbeddedChannelId;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedChannelTest {
    @Test
    public void testParent() {
        EmbeddedChannel parent = new EmbeddedChannel();
        EmbeddedChannel channel = new EmbeddedChannel((Channel)parent, EmbeddedChannelId.INSTANCE, true, false, new ChannelHandler[0]);
        Assert.assertSame((Object)parent, (Object)channel.parent());
        Assert.assertNull((Object)parent.parent());
        Assert.assertFalse((boolean)channel.finish());
        Assert.assertFalse((boolean)parent.finish());
    }

    @Test
    public void testNotRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[0]);
        Assert.assertFalse((boolean)channel.isRegistered());
        channel.register();
        Assert.assertTrue((boolean)channel.isRegistered());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(true, false, new ChannelHandler[0]);
        Assert.assertTrue((boolean)channel.isRegistered());
        try {
            channel.register();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test(timeout=2000L)
    public void promiseDoesNotInfiniteLoop() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                future.channel().close();
            }
        });
        channel.close().syncUninterruptibly();
    }

    @Test
    public void testConstructWithChannelInitializer() {
        final Integer first = 1;
        final Integer second = 2;
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.fireChannelRead((Object)first);
                ctx.fireChannelRead((Object)second);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>((ChannelHandler)handler){
            final /* synthetic */ ChannelHandler val$handler;
            {
                this.val$handler = channelHandler;
            }

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{this.val$handler});
            }
        }});
        ChannelPipeline pipeline = channel.pipeline();
        Assert.assertSame((Object)handler, (Object)pipeline.firstContext().handler());
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{3}));
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertSame((Object)first, (Object)channel.readInbound());
        Assert.assertSame((Object)second, (Object)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testScheduling() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        final CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture future = ch.eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        }, 1L, TimeUnit.SECONDS);
        future.addListener((GenericFutureListener)new FutureListener(){

            public void operationComplete(Future future) throws Exception {
                latch.countDown();
            }
        });
        long next = ch.runScheduledPendingTasks();
        Assert.assertTrue((next > 0L ? 1 : 0) != 0);
        Thread.sleep(TimeUnit.NANOSECONDS.toMillis(next) + 50L);
        Assert.assertEquals((long)-1L, (long)ch.runScheduledPendingTasks());
        latch.await();
    }

    @Test
    public void testScheduledCancelled() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ScheduledFuture future = ch.eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
            }
        }, 1L, TimeUnit.DAYS);
        ch.finish();
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test(timeout=3000L)
    public void testHandlerAddedExecutedInEventLoop() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        ChannelHandlerAdapter handler = new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                try {
                    Assert.assertTrue((boolean)ctx.executor().inEventLoop());
                }
                catch (Throwable cause) {
                    error.set(cause);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Assert.assertFalse((boolean)channel.finish());
        latch.await();
        Throwable cause = (Throwable)error.get();
        if (cause != null) {
            throw cause;
        }
    }

    @Test
    public void testConstructWithOutHandler() {
        EmbeddedChannel channel = new EmbeddedChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{1}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{2}));
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertSame((Object)1, (Object)channel.readInbound());
        Assert.assertNull((Object)channel.readInbound());
        Assert.assertSame((Object)2, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testConstructWithChannelId() {
        CustomChannelId channelId = new CustomChannelId(1);
        EmbeddedChannel channel = new EmbeddedChannel((ChannelId)channelId);
        Assert.assertSame((Object)channelId, (Object)channel.id());
    }

    @Test(timeout=2000L)
    public void testFireChannelInactiveAndUnregisteredOnClose() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.close();
            }
        });
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.close(channel.newPromise());
            }
        });
    }

    @Test(timeout=2000L)
    public void testFireChannelInactiveAndUnregisteredOnDisconnect() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.disconnect();
            }
        });
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.disconnect(channel.newPromise());
            }
        });
    }

    private static void testFireChannelInactiveAndUnregistered(Action action) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
                ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        action.doRun((Channel)channel).syncUninterruptibly();
        latch.await();
    }

    @Test
    public void testHasDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(true, new ChannelHandler[]{handler});
        Assert.assertTrue((boolean)channel.disconnect().isSuccess());
        Assert.assertTrue((boolean)channel.close().isSuccess());
        Assert.assertEquals((Object)EventOutboundHandler.DISCONNECT, (Object)handler.pollEvent());
        Assert.assertEquals((Object)EventOutboundHandler.CLOSE, (Object)handler.pollEvent());
        Assert.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{handler});
        Assert.assertTrue((boolean)channel.disconnect().isSuccess());
        Assert.assertTrue((boolean)channel.close().isSuccess());
        Assert.assertEquals((Object)EventOutboundHandler.CLOSE, (Object)handler.pollEvent());
        Assert.assertEquals((Object)EventOutboundHandler.CLOSE, (Object)handler.pollEvent());
        Assert.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnectSkipDisconnect() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                promise.tryFailure(new Throwable());
            }
        }});
        Assert.assertFalse((boolean)channel.disconnect().isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinishAndReleaseAll() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assert.assertEquals((long)1L, (long)in.refCnt());
            Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assert.assertEquals((long)1L, (long)out.refCnt());
            Assert.assertTrue((boolean)channel.finishAndReleaseAll());
            Assert.assertEquals((long)0L, (long)in.refCnt());
            Assert.assertEquals((long)0L, (long)out.refCnt());
            Assert.assertNull((Object)channel.readInbound());
            Assert.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseInbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assert.assertEquals((long)1L, (long)in.refCnt());
            Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assert.assertEquals((long)1L, (long)out.refCnt());
            Assert.assertTrue((boolean)channel.releaseInbound());
            Assert.assertEquals((long)0L, (long)in.refCnt());
            Assert.assertEquals((long)1L, (long)out.refCnt());
            Assert.assertTrue((boolean)channel.finish());
            Assert.assertNull((Object)channel.readInbound());
            ByteBuf buffer = (ByteBuf)channel.readOutbound();
            Assert.assertSame((Object)out, (Object)buffer);
            buffer.release();
            Assert.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseOutbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assert.assertEquals((long)1L, (long)in.refCnt());
            Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assert.assertEquals((long)1L, (long)out.refCnt());
            Assert.assertTrue((boolean)channel.releaseOutbound());
            Assert.assertEquals((long)1L, (long)in.refCnt());
            Assert.assertEquals((long)0L, (long)out.refCnt());
            Assert.assertTrue((boolean)channel.finish());
            Assert.assertNull((Object)channel.readOutbound());
            ByteBuf buffer = (ByteBuf)channel.readInbound();
            Assert.assertSame((Object)in, (Object)buffer);
            buffer.release();
            Assert.assertNull((Object)channel.readInbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    @Test
    public void testWriteLater() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) throws Exception {
                ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ctx.write(msg, promise);
                    }
                });
            }
        }});
        Object msg = new Object();
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{msg}));
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertSame((Object)msg, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testWriteScheduled() throws InterruptedException {
        int delay = 500;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) throws Exception {
                ctx.executor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ctx.writeAndFlush(msg, promise);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }});
        Object msg = new Object();
        Assert.assertFalse((boolean)channel.writeOutbound(new Object[]{msg}));
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)channel.finish());
        Assert.assertSame((Object)msg, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testFlushInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        channel.flushInbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #channelReadComplete() in time.");
        }
    }

    @Test
    public void testWriteOneInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ReferenceCountUtil.release((Object)msg);
                latch.countDown();
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #channelRead() in time.");
        }
        channel.close().syncUninterruptibly();
        Assert.assertEquals((long)0L, (long)flushCount.get());
    }

    @Test
    public void testFlushOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #flush() in time.");
        }
    }

    @Test
    public void testWriteOneOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                ctx.write(msg, promise);
                latch.countDown();
            }

            public void flush(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #write() in time.");
        }
        channel.close().syncUninterruptibly();
        Assert.assertEquals((long)0L, (long)flushCount.get());
    }

    @Test
    public void testEnsureOpen() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.close().syncUninterruptibly();
        try {
            channel.writeOutbound(new Object[]{"Hello, Netty!"});
            Assert.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
        try {
            channel.writeInbound(new Object[]{"Hello, Netty!"});
            Assert.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
    }

    @Test
    public void testHandleInboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleInboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #handleInboundMessage() in time.");
        }
    }

    @Test
    public void testHandleOutboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleOutboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (latch.await(50L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Somebody called unexpectedly #flush()");
        }
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Nobody called #handleOutboundMessage() in time.");
        }
    }

    @Test(timeout=5000L)
    public void testChannelInactiveFired() throws InterruptedException {
        final AtomicBoolean inactive = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                inactive.set(true);
            }
        }});
        channel.pipeline().fireExceptionCaught((Throwable)new IllegalStateException());
        Assert.assertTrue((boolean)inactive.get());
    }

    private static void release(ByteBuf ... buffers) {
        for (ByteBuf buffer : buffers) {
            if (buffer.refCnt() <= 0) continue;
            buffer.release();
        }
    }

    private static final class EventOutboundHandler
    extends ChannelOutboundHandlerAdapter {
        static final Integer DISCONNECT = 0;
        static final Integer CLOSE = 1;
        private final Queue<Integer> queue = new ArrayDeque<Integer>();

        private EventOutboundHandler() {
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.queue.add(DISCONNECT);
            promise.setSuccess();
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.queue.add(CLOSE);
            promise.setSuccess();
        }

        Integer pollEvent() {
            return this.queue.poll();
        }
    }

    private static interface Action {
        public ChannelFuture doRun(Channel var1);
    }
}

