/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoalescingBufferQueueTest {
    private ByteBuf cat;
    private ByteBuf mouse;
    private ChannelPromise catPromise;
    private ChannelPromise emptyPromise;
    private ChannelPromise voidPromise;
    private ChannelFutureListener mouseListener;
    private boolean mouseDone;
    private boolean mouseSuccess;
    private EmbeddedChannel channel;
    private CoalescingBufferQueue writeQueue;

    @Before
    public void setup() {
        this.mouseDone = false;
        this.mouseSuccess = false;
        this.channel = new EmbeddedChannel();
        this.writeQueue = new CoalescingBufferQueue((Channel)this.channel, 16, true);
        this.catPromise = this.newPromise();
        this.mouseListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                CoalescingBufferQueueTest.this.mouseDone = true;
                CoalescingBufferQueueTest.this.mouseSuccess = future.isSuccess();
            }
        };
        this.emptyPromise = this.newPromise();
        this.voidPromise = this.channel.voidPromise();
        this.cat = Unpooled.wrappedBuffer((byte[])"cat".getBytes(CharsetUtil.US_ASCII));
        this.mouse = Unpooled.wrappedBuffer((byte[])"mouse".getBytes(CharsetUtil.US_ASCII));
    }

    @After
    public void finish() {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testAddFirstPromiseRetained() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"catmous", (Object)this.dequeue(7, aggregatePromise));
        ByteBuf remainder = Unpooled.wrappedBuffer((byte[])"mous".getBytes(CharsetUtil.US_ASCII));
        this.writeQueue.addFirst(remainder, aggregatePromise);
        ChannelPromise aggregatePromise2 = this.newPromise();
        Assert.assertEquals((Object)"mouse", (Object)this.dequeue(5, aggregatePromise2));
        aggregatePromise2.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testAddFirstVoidPromise() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"catmous", (Object)this.dequeue(7, aggregatePromise));
        ByteBuf remainder = Unpooled.wrappedBuffer((byte[])"mous".getBytes(CharsetUtil.US_ASCII));
        this.writeQueue.addFirst(remainder, this.voidPromise);
        ChannelPromise aggregatePromise2 = this.newPromise();
        Assert.assertEquals((Object)"mouse", (Object)this.dequeue(5, aggregatePromise2));
        aggregatePromise2.setSuccess();
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.mouseSuccess);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testAggregateWithFullRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testWithVoidPromise() {
        this.writeQueue.add(this.cat, this.voidPromise);
        this.writeQueue.add(this.mouse, this.voidPromise);
        this.assertQueueSize(8, false);
        Assert.assertEquals((Object)"catm", (Object)this.dequeue(4, this.newPromise()));
        this.assertQueueSize(4, false);
        Assert.assertEquals((Object)"ouse", (Object)this.dequeue(4, this.newPromise()));
        this.assertQueueSize(0, true);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testAggregateWithPartialRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"catm", (Object)this.dequeue(4, aggregatePromise));
        this.assertQueueSize(4, false);
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"ouse", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testReadExactAddedBufferSizeReturnsOriginal() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertSame((Object)this.cat, (Object)this.writeQueue.remove(3, aggregatePromise));
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertEquals((long)1L, (long)this.cat.refCnt());
        this.cat.release();
        aggregatePromise = this.newPromise();
        Assert.assertSame((Object)this.mouse, (Object)this.writeQueue.remove(5, aggregatePromise));
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)1L, (long)this.mouse.refCnt());
        this.mouse.release();
    }

    @Test
    public void testReadEmptyQueueReturnsEmptyBuffer() {
        this.cat.release();
        this.mouse.release();
        this.assertQueueSize(0, true);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testReleaseAndFailAll() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        RuntimeException cause = new RuntimeException("ooops");
        this.writeQueue.releaseAndFailAll((Throwable)cause);
        ChannelPromise aggregatePromise = this.newPromise();
        this.assertQueueSize(0, true);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
        Assert.assertSame((Object)cause, (Object)this.catPromise.cause());
        Assert.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testEmptyBuffersAreCoalesced() {
        ByteBuf empty = Unpooled.buffer((int)0, (int)1);
        this.assertQueueSize(0, true);
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(empty, this.emptyPromise);
        this.assertQueueSize(3, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"cat", (Object)this.dequeue(3, aggregatePromise));
        this.assertQueueSize(0, true);
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        Assert.assertFalse((boolean)this.emptyPromise.isSuccess());
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.emptyPromise.isSuccess());
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)empty.refCnt());
    }

    @Test
    public void testMerge() {
        this.writeQueue.add(this.cat, this.catPromise);
        CoalescingBufferQueue otherQueue = new CoalescingBufferQueue((Channel)this.channel);
        otherQueue.add(this.mouse, this.mouseListener);
        otherQueue.copyTo((AbstractCoalescingBufferQueue)this.writeQueue);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assert.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assert.assertFalse((boolean)this.catPromise.isSuccess());
        Assert.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assert.assertTrue((boolean)this.catPromise.isSuccess());
        Assert.assertTrue((boolean)this.mouseSuccess);
        Assert.assertEquals((long)0L, (long)this.cat.refCnt());
        Assert.assertEquals((long)0L, (long)this.mouse.refCnt());
    }

    @Test
    public void testWritabilityChanged() {
        this.testWritabilityChanged0(false);
    }

    @Test
    public void testWritabilityChangedFailAll() {
        this.testWritabilityChanged0(true);
    }

    private void testWritabilityChanged0(boolean fail) {
        this.channel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(3, 4));
        Assert.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}));
        Assert.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5}));
        Assert.assertFalse((boolean)this.channel.isWritable());
        Assert.assertEquals((long)5L, (long)this.writeQueue.readableBytes());
        if (fail) {
            this.writeQueue.releaseAndFailAll((Throwable)new IllegalStateException());
        } else {
            ByteBuf buffer = this.writeQueue.removeFirst(this.voidPromise);
            Assert.assertEquals((long)1L, (long)buffer.readByte());
            Assert.assertEquals((long)2L, (long)buffer.readByte());
            Assert.assertEquals((long)3L, (long)buffer.readByte());
            Assert.assertFalse((boolean)buffer.isReadable());
            buffer.release();
            Assert.assertTrue((boolean)this.channel.isWritable());
            buffer = this.writeQueue.removeFirst(this.voidPromise);
            Assert.assertEquals((long)4L, (long)buffer.readByte());
            Assert.assertEquals((long)5L, (long)buffer.readByte());
            Assert.assertFalse((boolean)buffer.isReadable());
            buffer.release();
        }
        Assert.assertTrue((boolean)this.channel.isWritable());
        Assert.assertTrue((boolean)this.writeQueue.isEmpty());
    }

    private ChannelPromise newPromise() {
        return this.channel.newPromise();
    }

    private void assertQueueSize(int size, boolean isEmpty) {
        Assert.assertEquals((long)size, (long)this.writeQueue.readableBytes());
        if (isEmpty) {
            Assert.assertTrue((boolean)this.writeQueue.isEmpty());
        } else {
            Assert.assertFalse((boolean)this.writeQueue.isEmpty());
        }
    }

    private String dequeue(int numBytes, ChannelPromise aggregatePromise) {
        ByteBuf removed = this.writeQueue.remove(numBytes, aggregatePromise);
        String result = removed.toString(CharsetUtil.US_ASCII);
        ReferenceCountUtil.safeRelease((Object)removed);
        return result;
    }
}

