/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import org.junit.Assert;
import org.junit.Test;

public class AbstractCoalescingBufferQueueTest {
    @Test
    public void testDecrementAllWhenWriteAndRemoveAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(true);
    }

    @Test
    public void testDecrementAllWhenReleaseAndFailAll() {
        AbstractCoalescingBufferQueueTest.testDecrementAll(false);
    }

    private static void testDecrementAll(boolean write) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ReferenceCountUtil.release((Object)msg);
                promise.setSuccess();
            }
        }, new ChannelHandlerAdapter(){}});
        final AbstractCoalescingBufferQueue queue = new AbstractCoalescingBufferQueue((Channel)channel, 128){

            protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
                return this.composeIntoComposite(alloc, cumulation, next);
            }

            protected ByteBuf removeEmptyValue() {
                return Unpooled.EMPTY_BUFFER;
            }
        };
        final byte[] bytes = new byte[128];
        queue.add(Unpooled.wrappedBuffer((byte[])bytes), new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.add(Unpooled.wrappedBuffer((byte[])bytes));
                Assert.assertEquals((long)bytes.length, (long)queue.readableBytes());
            }
        });
        Assert.assertEquals((long)bytes.length, (long)queue.readableBytes());
        ChannelHandlerContext ctx = channel.pipeline().lastContext();
        if (write) {
            queue.writeAndRemoveAll(ctx);
        } else {
            queue.releaseAndFailAll((ChannelOutboundInvoker)ctx, (Throwable)new ClosedChannelException());
        }
        ByteBuf buffer = queue.remove(channel.alloc(), 128, channel.newPromise());
        Assert.assertFalse((boolean)buffer.isReadable());
        buffer.release();
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((long)0L, (long)queue.readableBytes());
        Assert.assertFalse((boolean)channel.finish());
    }
}

