/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelOption;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.NioChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractNioChannelTest<T extends AbstractNioChannel> {
    protected abstract T newNioChannel();

    protected abstract NetworkChannel jdkChannel(T var1);

    protected abstract SocketOption<?> newInvalidOption();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNioChannelOption() throws IOException {
        T channel = this.newNioChannel();
        try {
            NetworkChannel jdkChannel = this.jdkChannel(channel);
            ChannelOption option = NioChannelOption.of(StandardSocketOptions.SO_REUSEADDR);
            boolean value1 = jdkChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
            boolean value2 = (Boolean)channel.config().getOption(option);
            Assert.assertEquals((Object)value1, (Object)value2);
            channel.config().setOption(option, (Object)(!value2 ? 1 : 0));
            boolean value3 = jdkChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
            boolean value4 = (Boolean)channel.config().getOption(option);
            Assert.assertEquals((Object)value3, (Object)value4);
            Assert.assertNotEquals((Object)value1, (Object)value4);
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }

    @Test
    public void testInvalidNioChannelOption() {
        T channel = this.newNioChannel();
        try {
            ChannelOption option = NioChannelOption.of(this.newInvalidOption());
            Assert.assertFalse((boolean)channel.config().setOption(option, null));
            Assert.assertNull((Object)channel.config().getOption(option));
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }

    @Test
    public void testGetOptions() {
        T channel = this.newNioChannel();
        try {
            channel.config().getOptions();
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }
}

