/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalChannelTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannelTest.class);
    private static final LocalAddress TEST_ADDRESS = new LocalAddress("test.id");
    private static EventLoopGroup group1;
    private static EventLoopGroup group2;
    private static EventLoopGroup sharedGroup;

    @BeforeClass
    public static void beforeClass() {
        group1 = new DefaultEventLoopGroup(2);
        group2 = new DefaultEventLoopGroup(2);
        sharedGroup = new DefaultEventLoopGroup(1);
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        Future group1Future = group1.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        Future group2Future = group2.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        Future sharedGroupFuture = sharedGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        group1Future.await();
        group2Future.await();
        sharedGroupFuture.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalAddressReuse() throws Exception {
        for (int i = 0; i < 2; ++i) {
            Bootstrap cb = new Bootstrap();
            ServerBootstrap sb = new ServerBootstrap();
            ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
            ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
                final CountDownLatch latch = new CountDownLatch(1);
                final Channel ccCpy = cc = cb.connect(sc.localAddress()).sync().channel();
                cc.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        ccCpy.pipeline().fireChannelRead((Object)"Hello, World");
                        latch.countDown();
                    }
                });
                Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                sc.closeFuture().sync();
                Assert.assertNull((String)String.format("Expected null, got channel '%s' for local address '%s'", LocalChannelRegistry.get((SocketAddress)TEST_ADDRESS), TEST_ADDRESS), (Object)LocalChannelRegistry.get((SocketAddress)TEST_ADDRESS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFailsFastOnClosedChannel() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
        ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            cc = cb.connect(sc.localAddress()).sync().channel();
            cc.close().sync();
            try {
                cc.writeAndFlush(new Object()).sync();
                Assert.fail((String)"must raise a ClosedChannelException");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
                if (e.getStackTrace().length > 0) {
                    Assert.assertThat((Object)e.getStackTrace()[0].getClassName(), (Matcher)CoreMatchers.is((Object)(AbstractChannel.class.getName() + "$AbstractUnsafe")));
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerCloseChannelSameEventLoop() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.close();
                latch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group2)).channel(LocalChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                }
            });
            cc = b.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush(new Object());
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void localChannelRaceCondition() throws Exception {
        final CountDownLatch closeLatch = new CountDownLatch(1);
        DefaultEventLoopGroup clientGroup = new DefaultEventLoopGroup(1){

            protected EventLoop newChild(Executor threadFactory, Object ... args) throws Exception {
                return new SingleThreadEventLoop((EventLoopGroup)this, threadFactory, true){

                    protected void run() {
                        do {
                            Runnable task;
                            if ((task = this.takeTask()) == null) continue;
                            if (task.getClass().getEnclosingClass() == LocalChannel.class) {
                                try {
                                    closeLatch.await();
                                }
                                catch (InterruptedException e) {
                                    throw new Error(e);
                                }
                            }
                            task.run();
                            this.updateLastExecutionTime();
                        } while (!this.confirmShutdown());
                    }
                };
            }
        };
        Channel sc = null;
        Channel cc = null;
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sc = ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.close();
                    closeLatch.countDown();
                }
            }).bind((SocketAddress)TEST_ADDRESS).sync().channel();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)clientGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                }
            });
            ChannelFuture future = bootstrap.connect(sc.localAddress());
            Assert.assertTrue((String)"Connection should finish, not time out", (boolean)future.await(200L));
            cc = future.channel();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            clientGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).await();
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
        clientGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReRegister() {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
        ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
            cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
            cc.deregister().syncUninterruptibly();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseInWritePromiseCompletePreservesOrder() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        try {
            ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
            ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg.equals(data)) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    messageLatch.countDown();
                    super.channelInactive(ctx);
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
                final Channel ccCpy = cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
                cc.pipeline().lastContext().executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPromise promise = ccCpy.newPromise();
                        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ccCpy.pipeline().lastContext().close();
                            }
                        });
                        ccCpy.writeAndFlush((Object)data.retainedDuplicate(), promise);
                    }
                });
                Assert.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)cc.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAfterWriteInSameEventLoopPreservesOrder() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(3);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        try {
            ((Bootstrap)((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.writeAndFlush((Object)data.retainedDuplicate());
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data.equals(msg)) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }
            });
            ((ServerBootstrap)sb.group(sharedGroup).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data.equals(msg)) {
                        messageLatch.countDown();
                        ctx.writeAndFlush((Object)data);
                        ctx.close();
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    messageLatch.countDown();
                    super.channelInactive(ctx);
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
                cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
                Assert.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)cc.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteInWritePromiseCompletePreservesOrder() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        try {
            ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
            ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    long count = messageLatch.getCount();
                    if (data.equals(msg) && count == 2L || data2.equals(msg) && count == 1L) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
                final Channel ccCpy = cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
                cc.pipeline().lastContext().executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPromise promise = ccCpy.newPromise();
                        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                ccCpy.writeAndFlush((Object)data2.retainedDuplicate(), ccCpy.newPromise());
                            }
                        });
                        ccCpy.writeAndFlush((Object)data.retainedDuplicate(), promise);
                    }
                });
                Assert.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteDifferentEventLoopPreservesOrder() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (data2.equals(msg)) {
                    ReferenceCountUtil.safeRelease((Object)msg);
                    messageLatch.countDown();
                } else {
                    super.channelRead(ctx, msg);
                }
            }
        });
        ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (data.equals(msg)) {
                            ReferenceCountUtil.safeRelease((Object)msg);
                            messageLatch.countDown();
                        } else {
                            super.channelRead(ctx, msg);
                        }
                    }
                }});
                serverChannelRef.set(ch);
                serverChannelLatch.countDown();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
            cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
            Assert.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            final Channel ccCpy = cc;
            cc.pipeline().lastContext().executor().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelPromise promise = ccCpy.newPromise();
                    promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Channel serverChannelCpy = (Channel)serverChannelRef.get();
                            serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate(), serverChannelCpy.newPromise());
                        }
                    });
                    ccCpy.writeAndFlush((Object)data.retainedDuplicate(), promise);
                }
            });
            Assert.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            data.release();
            data2.release();
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
        data.release();
        data2.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerWriteInWritePromiseCompleteSameEventLoopPreservesOrder() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch messageLatch = new CountDownLatch(2);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        try {
            ((Bootstrap)((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (data2.equals(msg) && messageLatch.getCount() == 1L) {
                        ReferenceCountUtil.safeRelease((Object)msg);
                        messageLatch.countDown();
                    } else {
                        super.channelRead(ctx, msg);
                    }
                }
            });
            ((ServerBootstrap)sb.group(sharedGroup).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (data.equals(msg) && messageLatch.getCount() == 2L) {
                                ReferenceCountUtil.safeRelease((Object)msg);
                                messageLatch.countDown();
                            } else {
                                super.channelRead(ctx, msg);
                            }
                        }
                    }});
                    serverChannelRef.set(ch);
                    serverChannelLatch.countDown();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
                cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
                Assert.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
                final Channel ccCpy = cc;
                cc.pipeline().lastContext().executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPromise promise = ccCpy.newPromise();
                        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                Channel serverChannelCpy = (Channel)serverChannelRef.get();
                                serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate(), serverChannelCpy.newPromise());
                            }
                        });
                        ccCpy.writeAndFlush((Object)data.retainedDuplicate(), promise);
                    }
                });
                Assert.assertTrue((boolean)messageLatch.await(5L, TimeUnit.SECONDS));
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWhilePeerIsClosedReleaseObjectAndFailPromise() throws InterruptedException {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        final CountDownLatch serverMessageLatch = new CountDownLatch(1);
        LatchChannelFutureListener serverChannelCloseLatch = new LatchChannelFutureListener(1);
        LatchChannelFutureListener clientChannelCloseLatch = new LatchChannelFutureListener(1);
        final CountDownLatch writeFailLatch = new CountDownLatch(1);
        final ByteBuf data = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        final ByteBuf data2 = Unpooled.wrappedBuffer((byte[])new byte[512]);
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final AtomicReference serverChannelRef = new AtomicReference();
        try {
            ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler());
            ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                public void initChannel(LocalChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (data.equals(msg)) {
                                ReferenceCountUtil.safeRelease((Object)msg);
                                serverMessageLatch.countDown();
                            } else {
                                super.channelRead(ctx, msg);
                            }
                        }
                    }});
                    serverChannelRef.set(ch);
                    serverChannelLatch.countDown();
                }
            });
            Channel sc = null;
            Channel cc = null;
            try {
                sc = sb.bind((SocketAddress)TEST_ADDRESS).syncUninterruptibly().channel();
                cc = cb.connect(sc.localAddress()).syncUninterruptibly().channel();
                Assert.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
                final Channel ccCpy = cc;
                final Channel serverChannelCpy = (Channel)serverChannelRef.get();
                serverChannelCpy.closeFuture().addListener((GenericFutureListener)serverChannelCloseLatch);
                ccCpy.closeFuture().addListener((GenericFutureListener)clientChannelCloseLatch);
                cc.pipeline().lastContext().executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ccCpy.writeAndFlush((Object)data.retainedDuplicate(), ccCpy.newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                serverChannelCpy.eventLoop().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        int waitCount = 0;
                                        while (ccCpy.isOpen()) {
                                            try {
                                                Thread.sleep(50L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                            if (++waitCount <= 5) continue;
                                            Assert.fail();
                                        }
                                        serverChannelCpy.writeAndFlush((Object)data2.retainedDuplicate(), serverChannelCpy.newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                                            public void operationComplete(ChannelFuture future) throws Exception {
                                                if (!future.isSuccess() && future.cause() instanceof ClosedChannelException) {
                                                    writeFailLatch.countDown();
                                                }
                                            }
                                        });
                                    }
                                });
                                ccCpy.close();
                            }
                        });
                    }
                });
                Assert.assertTrue((boolean)serverMessageLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)writeFailLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)serverChannelCloseLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)clientChannelCloseLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)ccCpy.isOpen());
                Assert.assertFalse((boolean)serverChannelCpy.isOpen());
            }
            catch (Throwable throwable) {
                LocalChannelTest.closeChannel(cc);
                LocalChannelTest.closeChannel(sc);
                throw throwable;
            }
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
        }
        finally {
            data.release();
            data2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testConnectFutureBeforeChannelActive() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ((ServerBootstrap)sb.group(group2).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new TestHandler()});
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            cc = cb.register().sync().channel();
            final ChannelPromise promise = cc.newPromise();
            final Promise assertPromise = cc.eventLoop().newPromise();
            cc.pipeline().addLast(new ChannelHandler[]{new TestHandler(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (promise.isDone()) {
                        assertPromise.setSuccess(null);
                    } else {
                        assertPromise.setFailure((Throwable)((Object)new AssertionError((Object)"connect promise should be done")));
                    }
                }
            }});
            cc.connect(sc.localAddress(), promise).sync();
            assertPromise.syncUninterruptibly();
            Assert.assertTrue((boolean)promise.isSuccess());
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test(expected=ConnectException.class)
    public void testConnectionRefused() {
        Bootstrap sb = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)sb.group(group1)).channel(LocalChannel.class)).handler((ChannelHandler)new TestHandler())).connect((SocketAddress)LocalAddress.ANY).syncUninterruptibly();
    }

    private static void closeChannel(Channel cc) {
        if (cc != null) {
            cc.close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotLeakBuffersWhenCloseByRemotePeer() throws Exception {
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(sharedGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<ByteBuf>(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.writeAndFlush((Object)ctx.alloc().buffer().writeZero(100));
            }

            public void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            }
        });
        ((ServerBootstrap)sb.group(sharedGroup).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    public void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
                        while (buffer.isReadable()) {
                            ctx.write((Object)buffer.readRetainedSlice(1));
                        }
                        ctx.flush();
                        ctx.close();
                    }
                }});
            }
        });
        Channel sc = null;
        LocalChannel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            cc = (LocalChannel)cb.connect(sc.localAddress()).sync().channel();
            LocalChannelTest.closeChannel((Channel)cc);
            Assert.assertTrue((boolean)cc.inboundBuffer.isEmpty());
            LocalChannelTest.closeChannel(sc);
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel((Channel)cc);
        LocalChannelTest.closeChannel(sc);
    }

    private static void writeAndFlushReadOnSuccess(final ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.read();
                }
            }
        });
    }

    @Test(timeout=5000L)
    public void testAutoReadDisabledSharedGroup() throws Exception {
        LocalChannelTest.testAutoReadDisabled(sharedGroup, sharedGroup);
    }

    @Test(timeout=5000L)
    public void testAutoReadDisabledDifferentGroup() throws Exception {
        LocalChannelTest.testAutoReadDisabled(group1, group2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAutoReadDisabled(EventLoopGroup serverGroup, EventLoopGroup clientGroup) throws Exception {
        final CountDownLatch latch = new CountDownLatch(100);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class)).option(ChannelOption.AUTO_READ, (Object)false)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                LocalChannelTest.writeAndFlushReadOnSuccess(ctx, "test");
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                LocalChannelTest.writeAndFlushReadOnSuccess(ctx, msg);
            }
        });
        ((ServerBootstrap)sb.group(clientGroup).channel(LocalServerChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)false).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.read();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                latch.countDown();
                if (latch.getCount() > 0L) {
                    LocalChannelTest.writeAndFlushReadOnSuccess(ctx, msg);
                }
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            cc = cb.connect((SocketAddress)TEST_ADDRESS).sync().channel();
            latch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test(timeout=5000L)
    public void testMaxMessagesPerReadRespectedWithAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(sharedGroup, sharedGroup, true);
    }

    @Test(timeout=5000L)
    public void testMaxMessagesPerReadRespectedWithoutAutoReadSharedGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(sharedGroup, sharedGroup, false);
    }

    @Test(timeout=5000L)
    public void testMaxMessagesPerReadRespectedWithAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(group1, group2, true);
    }

    @Test(timeout=5000L)
    public void testMaxMessagesPerReadRespectedWithoutAutoReadDifferentGroup() throws Exception {
        LocalChannelTest.testMaxMessagesPerReadRespected(group1, group2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testMaxMessagesPerReadRespected(EventLoopGroup serverGroup, EventLoopGroup clientGroup, boolean autoRead) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(5);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class)).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1)).handler((ChannelHandler)new ChannelReadHandler(countDownLatch, autoRead));
        ((ServerBootstrap)sb.group(clientGroup).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                for (int i = 0; i < 10; ++i) {
                    ctx.write((Object)i);
                }
                ctx.flush();
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            cc = cb.connect((SocketAddress)TEST_ADDRESS).sync().channel();
            countDownLatch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(cc);
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(cc);
        LocalChannelTest.closeChannel(sc);
    }

    @Test(timeout=5000L)
    public void testServerMaxMessagesPerReadRespectedWithAutoReadSharedGroup() throws Exception {
        this.testServerMaxMessagesPerReadRespected(sharedGroup, sharedGroup, true);
    }

    @Test(timeout=5000L)
    public void testServerMaxMessagesPerReadRespectedWithoutAutoReadSharedGroup() throws Exception {
        this.testServerMaxMessagesPerReadRespected(sharedGroup, sharedGroup, false);
    }

    @Test(timeout=5000L)
    public void testServerMaxMessagesPerReadRespectedWithAutoReadDifferentGroup() throws Exception {
        this.testServerMaxMessagesPerReadRespected(group1, group2, true);
    }

    @Test(timeout=5000L)
    public void testServerMaxMessagesPerReadRespectedWithoutAutoReadDifferentGroup() throws Exception {
        this.testServerMaxMessagesPerReadRespected(group1, group2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testServerMaxMessagesPerReadRespected(EventLoopGroup serverGroup, EventLoopGroup clientGroup, boolean autoRead) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(5);
        Bootstrap cb = new Bootstrap();
        ServerBootstrap sb = new ServerBootstrap();
        ((Bootstrap)((Bootstrap)cb.group(serverGroup)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
            }
        });
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)sb.group(clientGroup).channel(LocalServerChannel.class)).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1)).handler((ChannelHandler)new ChannelReadHandler(countDownLatch, autoRead))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
            }
        });
        Channel sc = null;
        Channel cc = null;
        try {
            sc = sb.bind((SocketAddress)TEST_ADDRESS).sync().channel();
            for (int i = 0; i < 5; ++i) {
                try {
                    cc = cb.connect((SocketAddress)TEST_ADDRESS).sync().channel();
                }
                catch (Throwable throwable) {
                    LocalChannelTest.closeChannel(cc);
                    throw throwable;
                }
                LocalChannelTest.closeChannel(cc);
            }
            countDownLatch.await();
        }
        catch (Throwable throwable) {
            LocalChannelTest.closeChannel(sc);
            throw throwable;
        }
        LocalChannelTest.closeChannel(sc);
    }

    private static final class ChannelReadHandler
    extends ChannelInboundHandlerAdapter {
        private final CountDownLatch latch;
        private final boolean autoRead;
        private int read;

        ChannelReadHandler(CountDownLatch latch, boolean autoRead) {
            this.latch = latch;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (!this.autoRead) {
                ctx.read();
            }
            ctx.fireChannelActive();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Assert.assertEquals((long)0L, (long)this.read);
            ++this.read;
            ctx.fireChannelRead(msg);
        }

        public void channelReadComplete(final ChannelHandlerContext ctx) {
            Assert.assertEquals((long)1L, (long)this.read);
            this.latch.countDown();
            if (this.latch.getCount() > 0L) {
                if (!this.autoRead) {
                    ctx.executor().schedule(new Runnable(){

                        @Override
                        public void run() {
                            ChannelReadHandler.this.read = 0;
                            ctx.read();
                        }
                    }, 100L, TimeUnit.MILLISECONDS);
                } else {
                    this.read = 0;
                }
            } else {
                this.read = 0;
            }
            ctx.fireChannelReadComplete();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
            ctx.close();
        }
    }

    static class TestHandler
    extends ChannelInboundHandlerAdapter {
        TestHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            logger.info(String.format("Received message: %s", msg));
            ReferenceCountUtil.safeRelease((Object)msg);
        }
    }

    private static final class LatchChannelFutureListener
    extends CountDownLatch
    implements ChannelFutureListener {
        private LatchChannelFutureListener(int count) {
            super(count);
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.countDown();
        }
    }
}

