/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class BootstrapTest {
    private static final EventLoopGroup groupA = new DefaultEventLoopGroup(1);
    private static final EventLoopGroup groupB = new DefaultEventLoopGroup(1);
    private static final ChannelInboundHandler dummyHandler = new DummyHandler();

    @AfterClass
    public static void destroy() {
        groupA.shutdownGracefully();
        groupB.shutdownGracefully();
        groupA.terminationFuture().syncUninterruptibly();
        groupB.terminationFuture().syncUninterruptibly();
    }

    @Test(timeout=10000L)
    public void testBindDeadLock() throws Exception {
        final Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler((ChannelHandler)dummyHandler);
        final Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler((ChannelHandler)dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapB.bind((SocketAddress)LocalAddress.ANY);
                }
            }));
            bindFutures.add(groupB.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapA.bind((SocketAddress)LocalAddress.ANY);
                }
            }));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    @Test(timeout=10000L)
    public void testConnectDeadLock() throws Exception {
        final Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler((ChannelHandler)dummyHandler);
        final Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler((ChannelHandler)dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapB.connect((SocketAddress)LocalAddress.ANY);
                }
            }));
            bindFutures.add(groupB.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapA.connect((SocketAddress)LocalAddress.ANY);
                }
            }));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccess() throws Exception {
        TestEventLoopGroup group = new TestEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.channel(LocalServerChannel.class);
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            ChannelFuture future = bootstrap.bind();
            Assert.assertFalse((boolean)future.isDone());
            group.promise.setSuccess();
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    queue.add(future.channel().eventLoop().inEventLoop(Thread.currentThread()));
                    queue.add(future.isSuccess());
                }
            });
            Assert.assertTrue((boolean)((Boolean)queue.take()));
            Assert.assertTrue((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccessBindFailed() throws Exception {
        TestEventLoopGroup group = new TestEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.channelFactory((ChannelFactory)new ChannelFactory<ServerChannel>(){

                public ServerChannel newChannel() {
                    return new LocalServerChannel(){

                        public ChannelFuture bind(SocketAddress localAddress) {
                            this.close();
                            return this.newFailedFuture(new SocketException());
                        }

                        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
                            this.close();
                            return promise.setFailure((Throwable)new SocketException());
                        }
                    };
                }
            });
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            ChannelFuture future = bootstrap.bind();
            Assert.assertFalse((boolean)future.isDone());
            group.promise.setSuccess();
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    queue.add(future.channel().eventLoop().inEventLoop(Thread.currentThread()));
                    queue.add(future.isSuccess());
                }
            });
            Assert.assertTrue((boolean)((Boolean)queue.take()));
            Assert.assertFalse((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    @Test(expected=ConnectException.class, timeout=10000L)
    public void testLateRegistrationConnect() throws Exception {
        DelayedEventLoopGroup group = new DelayedEventLoopGroup();
        try {
            Bootstrap bootstrapA = new Bootstrap();
            bootstrapA.group((EventLoopGroup)group);
            bootstrapA.channel(LocalChannel.class);
            bootstrapA.handler((ChannelHandler)dummyHandler);
            bootstrapA.connect((SocketAddress)LocalAddress.ANY).syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAsyncResolutionSuccess() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(true));
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        bootstrapA.connect(localAddress).sync();
    }

    @Test
    public void testAsyncResolutionFailure() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(false));
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        ChannelFuture connectFuture = bootstrapA.connect(localAddress);
        Assert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnknownHostException.class)));
        Assert.assertThat((Object)connectFuture.channel().isOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetResolverFailed() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new AddressResolverGroup<SocketAddress>(){

            protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) {
                class TestException
                extends RuntimeException {
                    TestException() {
                    }
                }
                throw new TestException();
            }
        });
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        ChannelFuture connectFuture = bootstrapA.connect(localAddress);
        Assert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        Assert.assertThat((Object)connectFuture.cause().getCause(), (Matcher)Matchers.instanceOf(TestException.class));
        Assert.assertThat((Object)connectFuture.channel().isOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testChannelFactoryFailureNotifiesPromise() throws Exception {
        final RuntimeException exception = new RuntimeException("newChannel crash");
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler((ChannelHandler)dummyHandler)).group(groupA)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel() {
                throw exception;
            }
        });
        ChannelFuture connectFuture = bootstrap.connect((SocketAddress)LocalAddress.ANY);
        Assert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.sameInstance((Object)exception));
        Assert.assertThat((Object)connectFuture.channel(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void testChannelOptionOrderPreserve() throws InterruptedException {
        final LinkedBlockingQueue options = new LinkedBlockingQueue();
        final CountDownLatch latch = new CountDownLatch(1);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                latch.countDown();
            }
        })).group(groupA)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel() {
                return new LocalChannel(){
                    private 1ChannelConfigValidator config;

                    public synchronized ChannelConfig config() {
                        class ChannelConfigValidator
                        extends DefaultChannelConfig {
                            final /* synthetic */ BlockingQueue val$options;

                            ChannelConfigValidator(Channel channel) {
                                this.val$options = blockingQueue;
                                super(channel);
                            }

                            public <T> boolean setOption(ChannelOption<T> option, T value) {
                                this.val$options.add(option);
                                return super.setOption(option, value);
                            }
                        }
                        if (this.config == null) {
                            this.config = new ChannelConfigValidator(BootstrapTest.this, (Channel)this, options);
                        }
                        return this.config;
                    }
                };
            }
        })).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)1)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)2);
        bootstrap.register().syncUninterruptibly();
        latch.await();
        Assert.assertSame((Object)ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, options.take());
        Assert.assertSame((Object)ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, options.take());
    }

    private static final class TestAddressResolverGroup
    extends AddressResolverGroup<SocketAddress> {
        private final boolean success;

        TestAddressResolverGroup(boolean success) {
            this.success = success;
        }

        protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) throws Exception {
            return new AbstractAddressResolver<SocketAddress>(executor){

                protected boolean doIsResolved(SocketAddress address) {
                    return false;
                }

                protected void doResolve(final SocketAddress unresolvedAddress, final Promise<SocketAddress> promise) {
                    this.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (TestAddressResolverGroup.this.success) {
                                promise.setSuccess((Object)unresolvedAddress);
                            } else {
                                promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                            }
                        }
                    });
                }

                protected void doResolveAll(final SocketAddress unresolvedAddress, final Promise<List<SocketAddress>> promise) throws Exception {
                    this.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (TestAddressResolverGroup.this.success) {
                                promise.setSuccess(Collections.singletonList(unresolvedAddress));
                            } else {
                                promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                            }
                        }
                    });
                }
            };
        }
    }

    @ChannelHandler.Sharable
    private static final class DummyHandler
    extends ChannelInboundHandlerAdapter {
        private DummyHandler() {
        }
    }

    private static final class TestEventLoopGroup
    extends DefaultEventLoopGroup {
        ChannelPromise promise;

        TestEventLoopGroup() {
            super(1);
        }

        public ChannelFuture register(Channel channel) {
            super.register(channel).syncUninterruptibly();
            this.promise = channel.newPromise();
            return this.promise;
        }

        public ChannelFuture register(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture register(Channel channel, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DelayedEventLoopGroup
    extends DefaultEventLoop {
        private DelayedEventLoopGroup() {
        }

        public ChannelFuture register(final Channel channel, final ChannelPromise promise) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DelayedEventLoopGroup.super.register(channel, promise);
                }
            });
            return promise;
        }
    }
}

