/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannelHandlerContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerMask;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.UnorderedThreadPoolEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultChannelPipelineTest {
    private static EventLoopGroup group;
    private Channel self;
    private Channel peer;

    @BeforeClass
    public static void beforeClass() throws Exception {
        group = new DefaultEventLoopGroup(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        group.shutdownGracefully().sync();
    }

    private void setUp(final ChannelHandler ... handlers) throws Exception {
        final AtomicReference peerRef = new AtomicReference();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group(group).channel(LocalServerChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                peerRef.set(ctx.channel());
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ReferenceCountUtil.release((Object)msg);
            }
        });
        ChannelFuture bindFuture = sb.bind((SocketAddress)LocalAddress.ANY).sync();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)b.group(group)).channel(LocalChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(handlers);
            }
        });
        this.self = b.connect(bindFuture.channel().localAddress()).sync().channel();
        this.peer = (Channel)peerRef.get();
        bindFuture.channel().close().sync();
    }

    @After
    public void tearDown() throws Exception {
        if (this.peer != null) {
            this.peer.close();
            this.peer = null;
        }
        if (this.self != null) {
            this.self = null;
        }
    }

    @Test
    public void testFreeCalled() throws Exception {
        final CountDownLatch free = new CountDownLatch(1);
        AbstractReferenceCounted holder = new AbstractReferenceCounted(){

            protected void deallocate() {
                free.countDown();
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        };
        StringInboundHandler handler = new StringInboundHandler();
        this.setUp(new ChannelHandler[]{handler});
        this.peer.writeAndFlush((Object)holder).sync();
        Assert.assertTrue((boolean)free.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)handler.called);
    }

    @Test
    public void testRemoveChannelHandler() {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler2);
        pipeline.addLast("handler3", handler3);
        Assert.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        Assert.assertSame((Object)pipeline.get("handler2"), (Object)handler2);
        Assert.assertSame((Object)pipeline.get("handler3"), (Object)handler3);
        pipeline.remove(handler1);
        Assert.assertNull((Object)pipeline.get("handler1"));
        pipeline.remove(handler2);
        Assert.assertNull((Object)pipeline.get("handler2"));
        pipeline.remove(handler3);
        Assert.assertNull((Object)pipeline.get("handler3"));
    }

    @Test
    public void testRemoveIfExists() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)new LocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler2);
        pipeline.addLast("handler3", handler3);
        Assert.assertNotNull((Object)pipeline.removeIfExists(handler1));
        Assert.assertNull((Object)pipeline.get("handler1"));
        Assert.assertNotNull((Object)pipeline.removeIfExists("handler2"));
        Assert.assertNull((Object)pipeline.get("handler2"));
        Assert.assertNotNull((Object)pipeline.removeIfExists(TestHandler.class));
        Assert.assertNull((Object)pipeline.get("handler3"));
    }

    @Test
    public void testRemoveIfExistsDoesNotThrowException() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)new LocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        ChannelHandler handler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        Assert.assertNull((Object)pipeline.removeIfExists("handlerXXX"));
        Assert.assertNull((Object)pipeline.removeIfExists(handler2));
        Assert.assertNull((Object)pipeline.removeIfExists(ChannelOutboundHandlerAdapter.class));
        Assert.assertNotNull((Object)pipeline.get("handler1"));
    }

    @Test(expected=NoSuchElementException.class)
    public void testRemoveThrowNoSuchElementException() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline((Channel)new LocalChannel());
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.remove("handlerXXX");
    }

    @Test
    public void testReplaceChannelHandler() {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        ChannelHandler handler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.addLast("handler1", handler1);
        pipeline.addLast("handler2", handler1);
        pipeline.addLast("handler3", handler1);
        Assert.assertSame((Object)pipeline.get("handler1"), (Object)handler1);
        Assert.assertSame((Object)pipeline.get("handler2"), (Object)handler1);
        Assert.assertSame((Object)pipeline.get("handler3"), (Object)handler1);
        ChannelHandler newHandler1 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler1", "handler1", newHandler1);
        Assert.assertSame((Object)pipeline.get("handler1"), (Object)newHandler1);
        ChannelHandler newHandler3 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler3", "handler3", newHandler3);
        Assert.assertSame((Object)pipeline.get("handler3"), (Object)newHandler3);
        ChannelHandler newHandler2 = DefaultChannelPipelineTest.newHandler();
        pipeline.replace("handler2", "handler2", newHandler2);
        Assert.assertSame((Object)pipeline.get("handler2"), (Object)newHandler2);
    }

    @Test
    public void testChannelHandlerContextNavigation() {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        int HANDLER_ARRAY_LEN = 5;
        ChannelHandler[] firstHandlers = DefaultChannelPipelineTest.newHandlers(5);
        ChannelHandler[] lastHandlers = DefaultChannelPipelineTest.newHandlers(5);
        pipeline.addFirst(firstHandlers);
        pipeline.addLast(lastHandlers);
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 10);
    }

    @Test
    public void testFireChannelRegistered() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
                        latch.countDown();
                    }
                }});
            }
        }});
        group.register(pipeline.channel());
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testPipelineOperation() {
        int i;
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        int handlerNum = 5;
        ChannelHandler[] handlers1 = DefaultChannelPipelineTest.newHandlers(5);
        ChannelHandler[] handlers2 = DefaultChannelPipelineTest.newHandlers(5);
        String prefixX = "x";
        for (i = 0; i < 5; ++i) {
            if (i % 2 == 0) {
                pipeline.addFirst("x" + i, handlers1[i]);
                continue;
            }
            pipeline.addLast("x" + i, handlers1[i]);
        }
        for (i = 0; i < 5; ++i) {
            if (i % 2 != 0) {
                pipeline.addBefore("x" + i, String.valueOf(i), handlers2[i]);
                continue;
            }
            pipeline.addAfter("x" + i, String.valueOf(i), handlers2[i]);
        }
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 10);
    }

    @Test
    public void testChannelHandlerContextOrder() {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addFirst("1", DefaultChannelPipelineTest.newHandler());
        pipeline.addLast("10", DefaultChannelPipelineTest.newHandler());
        pipeline.addBefore("10", "5", DefaultChannelPipelineTest.newHandler());
        pipeline.addAfter("1", "3", DefaultChannelPipelineTest.newHandler());
        pipeline.addBefore("5", "4", DefaultChannelPipelineTest.newHandler());
        pipeline.addAfter("5", "6", DefaultChannelPipelineTest.newHandler());
        pipeline.addBefore("1", "0", DefaultChannelPipelineTest.newHandler());
        pipeline.addAfter("10", "11", DefaultChannelPipelineTest.newHandler());
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)pipeline.firstContext();
        Assert.assertNotNull((Object)ctx);
        while (ctx != null) {
            int i = DefaultChannelPipelineTest.toInt(ctx.name());
            int j = DefaultChannelPipelineTest.next(ctx);
            if (j != -1) {
                Assert.assertTrue((i < j ? 1 : 0) != 0);
            } else {
                Assert.assertNull((Object)ctx.next.next);
            }
            ctx = ctx.next;
        }
        DefaultChannelPipelineTest.verifyContextNumber(pipeline, 8);
    }

    @Test(timeout=10000L)
    public void testLifeCycleAwareness() throws Exception {
        this.setUp(new ChannelHandler[0]);
        ChannelPipeline p = this.self.pipeline();
        final ArrayList handlers = new ArrayList();
        int COUNT = 20;
        final CountDownLatch addLatch = new CountDownLatch(20);
        for (int i = 0; i < 20; ++i) {
            final LifeCycleAwareTestHandler handler = new LifeCycleAwareTestHandler("handler-" + i);
            p.addFirst(handler.name, (ChannelHandler)handler);
            this.self.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    handler.validate(true, false);
                    handlers.add(handler);
                    addLatch.countDown();
                }
            });
        }
        addLatch.await();
        Collections.shuffle(handlers);
        final CountDownLatch removeLatch = new CountDownLatch(20);
        for (final LifeCycleAwareTestHandler handler : handlers) {
            Assert.assertSame((Object)((Object)handler), (Object)p.remove(handler.name));
            this.self.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    handler.validate(true, true);
                    removeLatch.countDown();
                }
            });
        }
        removeLatch.await();
    }

    @Test(timeout=100000L)
    public void testRemoveAndForwardInbound() throws Exception {
        final BufferedTestHandler handler1 = new BufferedTestHandler();
        final BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(new ChannelHandler[]{handler1, handler2});
        this.self.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ChannelPipeline p = DefaultChannelPipelineTest.this.self.pipeline();
                handler1.inboundBuffer.add(8);
                Assert.assertEquals((Object)8, (Object)handler1.inboundBuffer.peek());
                Assert.assertTrue((boolean)handler2.inboundBuffer.isEmpty());
                p.remove((ChannelHandler)handler1);
                Assert.assertEquals((long)1L, (long)handler2.inboundBuffer.size());
                Assert.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
            }
        }).sync();
    }

    @Test(timeout=10000L)
    public void testRemoveAndForwardOutbound() throws Exception {
        final BufferedTestHandler handler1 = new BufferedTestHandler();
        final BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(new ChannelHandler[]{handler1, handler2});
        this.self.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ChannelPipeline p = DefaultChannelPipelineTest.this.self.pipeline();
                handler2.outboundBuffer.add(8);
                Assert.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
                Assert.assertTrue((boolean)handler1.outboundBuffer.isEmpty());
                p.remove((ChannelHandler)handler2);
                Assert.assertEquals((long)1L, (long)handler1.outboundBuffer.size());
                Assert.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
            }
        }).sync();
    }

    @Test(timeout=10000L)
    public void testReplaceAndForwardOutbound() throws Exception {
        final BufferedTestHandler handler1 = new BufferedTestHandler();
        final BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(new ChannelHandler[]{handler1});
        this.self.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ChannelPipeline p = DefaultChannelPipelineTest.this.self.pipeline();
                handler1.outboundBuffer.add(8);
                Assert.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
                Assert.assertTrue((boolean)handler2.outboundBuffer.isEmpty());
                p.replace((ChannelHandler)handler1, "handler2", (ChannelHandler)handler2);
                Assert.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
            }
        }).sync();
    }

    @Test(timeout=10000L)
    public void testReplaceAndForwardInboundAndOutbound() throws Exception {
        final BufferedTestHandler handler1 = new BufferedTestHandler();
        final BufferedTestHandler handler2 = new BufferedTestHandler();
        this.setUp(new ChannelHandler[]{handler1});
        this.self.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ChannelPipeline p = DefaultChannelPipelineTest.this.self.pipeline();
                handler1.inboundBuffer.add(8);
                handler1.outboundBuffer.add(8);
                Assert.assertEquals((Object)8, (Object)handler1.inboundBuffer.peek());
                Assert.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
                Assert.assertTrue((boolean)handler2.inboundBuffer.isEmpty());
                Assert.assertTrue((boolean)handler2.outboundBuffer.isEmpty());
                p.replace((ChannelHandler)handler1, "handler2", (ChannelHandler)handler2);
                Assert.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
                Assert.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
            }
        }).sync();
    }

    @Test(timeout=10000L)
    public void testRemoveAndForwardInboundOutbound() throws Exception {
        final BufferedTestHandler handler1 = new BufferedTestHandler();
        final BufferedTestHandler handler2 = new BufferedTestHandler();
        final BufferedTestHandler handler3 = new BufferedTestHandler();
        this.setUp(new ChannelHandler[]{handler1, handler2, handler3});
        this.self.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                ChannelPipeline p = DefaultChannelPipelineTest.this.self.pipeline();
                handler2.inboundBuffer.add(8);
                handler2.outboundBuffer.add(8);
                Assert.assertEquals((Object)8, (Object)handler2.inboundBuffer.peek());
                Assert.assertEquals((Object)8, (Object)handler2.outboundBuffer.peek());
                Assert.assertEquals((long)0L, (long)handler1.outboundBuffer.size());
                Assert.assertEquals((long)0L, (long)handler3.inboundBuffer.size());
                p.remove((ChannelHandler)handler2);
                Assert.assertEquals((Object)8, (Object)handler3.inboundBuffer.peek());
                Assert.assertEquals((Object)8, (Object)handler1.outboundBuffer.peek());
            }
        }).sync();
    }

    @Test
    public void testCancelBind() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ChannelFuture future = pipeline.bind((SocketAddress)new LocalAddress("test"), promise);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test
    public void testCancelConnect() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ChannelFuture future = pipeline.connect((SocketAddress)new LocalAddress("test"), promise);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test
    public void testCancelDisconnect() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ChannelFuture future = pipeline.disconnect(promise);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test
    public void testCancelClose() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ChannelFuture future = pipeline.close(promise);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testWrongPromiseChannel() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel()).sync();
        ChannelPipeline pipeline2 = new LocalChannel().pipeline();
        group.register(pipeline2.channel()).sync();
        try {
            ChannelPromise promise2 = pipeline2.channel().newPromise();
            pipeline.close(promise2);
        }
        finally {
            pipeline.close();
            pipeline2.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnexpectedVoidChannelPromise() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel()).sync();
        try {
            VoidChannelPromise promise = new VoidChannelPromise(pipeline.channel(), false);
            pipeline.close((ChannelPromise)promise);
        }
        finally {
            pipeline.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnexpectedVoidChannelPromiseCloseFuture() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel()).sync();
        try {
            ChannelPromise promise = (ChannelPromise)pipeline.channel().closeFuture();
            pipeline.close(promise);
        }
        finally {
            pipeline.close();
        }
    }

    @Test
    public void testCancelDeregister() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ChannelFuture future = pipeline.deregister(promise);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test
    public void testCancelWrite() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ByteBuf buffer = Unpooled.buffer();
        Assert.assertEquals((long)1L, (long)buffer.refCnt());
        ChannelFuture future = pipeline.write((Object)buffer, promise);
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testCancelWriteAndFlush() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        group.register(pipeline.channel());
        ChannelPromise promise = pipeline.channel().newPromise();
        Assert.assertTrue((boolean)promise.cancel(false));
        ByteBuf buffer = Unpooled.buffer();
        Assert.assertEquals((long)1L, (long)buffer.refCnt());
        ChannelFuture future = pipeline.writeAndFlush((Object)buffer, promise);
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testFirstContextEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        Assert.assertNull((Object)pipeline.firstContext());
    }

    @Test
    public void testLastContextEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        Assert.assertNull((Object)pipeline.lastContext());
    }

    @Test
    public void testFirstHandlerEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        Assert.assertNull((Object)pipeline.first());
    }

    @Test
    public void testLastHandlerEmptyPipeline() throws Exception {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        Assert.assertNull((Object)pipeline.last());
    }

    @Test(timeout=5000L)
    public void testChannelInitializerException() throws Exception {
        final IllegalStateException exception = new IllegalStateException();
        final AtomicReference error = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                throw exception;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                super.exceptionCaught(ctx, cause);
                error.set(cause);
                latch.countDown();
            }
        }});
        latch.await();
        Assert.assertFalse((boolean)channel.isActive());
        Assert.assertSame((Object)exception, error.get());
    }

    @Test
    public void testChannelUnregistrationWithCustomExecutor() throws Exception {
        final CountDownLatch channelLatch = new CountDownLatch(1);
        final CountDownLatch handlerLatch = new CountDownLatch(1);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)new WrapperExecutor(), new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                        channelLatch.countDown();
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                        handlerLatch.countDown();
                    }
                }});
            }
        }});
        Channel channel = pipeline.channel();
        group.register(channel);
        channel.close();
        channel.deregister();
        Assert.assertTrue((boolean)channelLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)handlerLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test(timeout=3000L)
    public void testAddHandlerBeforeRegisteredThenRemove() {
        EventLoop loop = group.next();
        CheckEventExecutorHandler handler = new CheckEventExecutorHandler((EventExecutor)loop);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        Assert.assertFalse((boolean)handler.addedPromise.isDone());
        group.register(pipeline.channel());
        handler.addedPromise.syncUninterruptibly();
        pipeline.remove((ChannelHandler)handler);
        handler.removedPromise.syncUninterruptibly();
    }

    @Test(timeout=3000L)
    public void testAddHandlerBeforeRegisteredThenReplace() throws Exception {
        EventLoop loop = group.next();
        final CountDownLatch latch = new CountDownLatch(1);
        CheckEventExecutorHandler handler = new CheckEventExecutorHandler((EventExecutor)loop);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        Assert.assertFalse((boolean)handler.addedPromise.isDone());
        group.register(pipeline.channel());
        handler.addedPromise.syncUninterruptibly();
        pipeline.replace((ChannelHandler)handler, null, (ChannelHandler)new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        });
        handler.removedPromise.syncUninterruptibly();
        latch.await();
    }

    @Test
    public void testAddRemoveHandlerNotRegistered() throws Throwable {
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        ErrorChannelHandler handler = new ErrorChannelHandler(error);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.remove((ChannelHandler)handler);
        Throwable cause = error.get();
        if (cause != null) {
            throw cause;
        }
    }

    @Test
    public void testAddReplaceHandlerNotRegistered() throws Throwable {
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        ErrorChannelHandler handler = new ErrorChannelHandler(error);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.replace((ChannelHandler)handler, null, (ChannelHandler)new ErrorChannelHandler(error));
        Throwable cause = error.get();
        if (cause != null) {
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testHandlerAddedAndRemovedCalledInCorrectOrder() throws Throwable {
        DefaultEventExecutorGroup group1 = new DefaultEventExecutorGroup(1);
        DefaultEventExecutorGroup group2 = new DefaultEventExecutorGroup(1);
        try {
            LinkedBlockingQueue<CheckOrderHandler> addedQueue = new LinkedBlockingQueue<CheckOrderHandler>();
            LinkedBlockingQueue<CheckOrderHandler> removedQueue = new LinkedBlockingQueue<CheckOrderHandler>();
            CheckOrderHandler handler1 = new CheckOrderHandler(addedQueue, removedQueue);
            CheckOrderHandler handler2 = new CheckOrderHandler(addedQueue, removedQueue);
            CheckOrderHandler handler3 = new CheckOrderHandler(addedQueue, removedQueue);
            CheckOrderHandler handler4 = new CheckOrderHandler(addedQueue, removedQueue);
            ChannelPipeline pipeline = new LocalChannel().pipeline();
            pipeline.addLast(new ChannelHandler[]{handler1});
            group.register(pipeline.channel()).syncUninterruptibly();
            pipeline.addLast((EventExecutorGroup)group1, new ChannelHandler[]{handler2});
            pipeline.addLast((EventExecutorGroup)group2, new ChannelHandler[]{handler3});
            pipeline.addLast(new ChannelHandler[]{handler4});
            Assert.assertTrue((boolean)removedQueue.isEmpty());
            pipeline.channel().close().syncUninterruptibly();
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)addedQueue.take()), handler1);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)addedQueue.take()), handler2, handler3, handler4);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)addedQueue.take()), handler2, handler3, handler4);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)addedQueue.take()), handler2, handler3, handler4);
            Assert.assertTrue((boolean)addedQueue.isEmpty());
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)removedQueue.take()), handler4);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)removedQueue.take()), handler3);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)removedQueue.take()), handler2);
            DefaultChannelPipelineTest.assertHandler((CheckOrderHandler)((Object)removedQueue.take()), handler1);
            Assert.assertTrue((boolean)removedQueue.isEmpty());
        }
        finally {
            group1.shutdownGracefully();
            group2.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testHandlerAddedExceptionFromChildHandlerIsPropagated() {
        DefaultEventExecutorGroup group1 = new DefaultEventExecutorGroup(1);
        try {
            Promise promise = group1.next().newPromise();
            final AtomicBoolean handlerAdded = new AtomicBoolean();
            final RuntimeException exception = new RuntimeException();
            ChannelPipeline pipeline = new LocalChannel().pipeline();
            pipeline.addLast((EventExecutorGroup)group1, new ChannelHandler[]{new CheckExceptionHandler(exception, (Promise<Void>)promise)});
            pipeline.addFirst(new ChannelHandler[]{new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    handlerAdded.set(true);
                    throw exception;
                }
            }});
            Assert.assertFalse((boolean)handlerAdded.get());
            group.register(pipeline.channel());
            promise.syncUninterruptibly();
        }
        finally {
            group1.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testHandlerRemovedExceptionFromChildHandlerIsPropagated() {
        DefaultEventExecutorGroup group1 = new DefaultEventExecutorGroup(1);
        try {
            Promise promise = group1.next().newPromise();
            String handlerName = "foo";
            final RuntimeException exception = new RuntimeException();
            ChannelPipeline pipeline = new LocalChannel().pipeline();
            pipeline.addLast(handlerName, (ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    throw exception;
                }
            });
            pipeline.addLast((EventExecutorGroup)group1, new ChannelHandler[]{new CheckExceptionHandler(exception, (Promise<Void>)promise)});
            group.register(pipeline.channel()).syncUninterruptibly();
            pipeline.remove(handlerName);
            promise.syncUninterruptibly();
        }
        finally {
            group1.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testHandlerAddedThrowsAndRemovedThrowsException() throws InterruptedException {
        DefaultEventExecutorGroup group1 = new DefaultEventExecutorGroup(1);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            Promise promise = group1.next().newPromise();
            final RuntimeException exceptionAdded = new RuntimeException();
            final RuntimeException exceptionRemoved = new RuntimeException();
            String handlerName = "foo";
            ChannelPipeline pipeline = new LocalChannel().pipeline();
            pipeline.addLast((EventExecutorGroup)group1, new ChannelHandler[]{new CheckExceptionHandler(exceptionAdded, (Promise<Void>)promise)});
            pipeline.addFirst(handlerName, (ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    throw exceptionAdded;
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    ctx.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            latch.countDown();
                        }
                    });
                    throw exceptionRemoved;
                }
            });
            group.register(pipeline.channel()).syncUninterruptibly();
            latch.await();
            Assert.assertNull((Object)pipeline.context(handlerName));
            promise.syncUninterruptibly();
        }
        finally {
            group1.shutdownGracefully();
        }
    }

    @Test(timeout=2000L)
    public void testAddRemoveHandlerCalledOnceRegistered() throws Throwable {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        CallbackCheckHandler handler = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.remove((ChannelHandler)handler);
        Assert.assertNull((Object)handler.addedHandler.getNow());
        Assert.assertNull((Object)handler.removedHandler.getNow());
        group.register(pipeline.channel()).syncUninterruptibly();
        Throwable cause = handler.error.get();
        if (cause != null) {
            throw cause;
        }
        Assert.assertTrue((boolean)((Boolean)handler.addedHandler.get()));
        Assert.assertTrue((boolean)((Boolean)handler.removedHandler.get()));
    }

    @Test(timeout=3000L)
    public void testAddReplaceHandlerCalledOnceRegistered() throws Throwable {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        CallbackCheckHandler handler = new CallbackCheckHandler();
        CallbackCheckHandler handler2 = new CallbackCheckHandler();
        pipeline.addFirst(new ChannelHandler[]{handler});
        pipeline.replace((ChannelHandler)handler, null, (ChannelHandler)handler2);
        Assert.assertNull((Object)handler.addedHandler.getNow());
        Assert.assertNull((Object)handler.removedHandler.getNow());
        Assert.assertNull((Object)handler2.addedHandler.getNow());
        Assert.assertNull((Object)handler2.removedHandler.getNow());
        group.register(pipeline.channel()).syncUninterruptibly();
        Throwable cause = handler.error.get();
        if (cause != null) {
            throw cause;
        }
        Assert.assertTrue((boolean)((Boolean)handler.addedHandler.get()));
        Assert.assertTrue((boolean)((Boolean)handler.removedHandler.get()));
        Throwable cause2 = handler2.error.get();
        if (cause2 != null) {
            throw cause2;
        }
        Assert.assertTrue((boolean)((Boolean)handler2.addedHandler.get()));
        Assert.assertNull((Object)handler2.removedHandler.getNow());
        pipeline.remove((ChannelHandler)handler2);
        Assert.assertTrue((boolean)((Boolean)handler2.removedHandler.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testAddBefore() throws Throwable {
        ChannelPipeline pipeline1 = new LocalChannel().pipeline();
        ChannelPipeline pipeline2 = new LocalChannel().pipeline();
        DefaultEventLoopGroup defaultGroup = new DefaultEventLoopGroup(2);
        try {
            EventLoop eventLoop1 = defaultGroup.next();
            EventLoop eventLoop2 = defaultGroup.next();
            eventLoop1.register(pipeline1.channel()).syncUninterruptibly();
            eventLoop2.register(pipeline2.channel()).syncUninterruptibly();
            CountDownLatch latch = new CountDownLatch(20);
            for (int i = 0; i < 10; ++i) {
                eventLoop1.execute((Runnable)new TestTask(pipeline2, latch));
                eventLoop2.execute((Runnable)new TestTask(pipeline1, latch));
            }
            latch.await();
        }
        finally {
            defaultGroup.shutdownGracefully();
        }
    }

    @Test(timeout=3000L)
    public void testAddInListenerNio() throws Throwable {
        DefaultChannelPipelineTest.testAddInListener((Channel)new NioSocketChannel(), (EventLoopGroup)new NioEventLoopGroup(1));
    }

    @Test(timeout=3000L)
    public void testAddInListenerOio() throws Throwable {
        DefaultChannelPipelineTest.testAddInListener((Channel)new OioSocketChannel(), (EventLoopGroup)new OioEventLoopGroup(1));
    }

    @Test(timeout=3000L)
    public void testAddInListenerLocal() throws Throwable {
        DefaultChannelPipelineTest.testAddInListener((Channel)new LocalChannel(), (EventLoopGroup)new DefaultEventLoopGroup(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddInListener(Channel channel, EventLoopGroup group) throws Throwable {
        ChannelPipeline pipeline1 = channel.pipeline();
        try {
            final Object event = new Object();
            final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
            group.register(pipeline1.channel()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelPipeline pipeline = future.channel().pipeline();
                    final AtomicBoolean handlerAddedCalled = new AtomicBoolean();
                    pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                            handlerAddedCalled.set(true);
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            promise.setSuccess(event);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            promise.setFailure(cause);
                        }
                    }});
                    if (!handlerAddedCalled.get()) {
                        promise.setFailure((Throwable)((Object)new AssertionError((Object)"handlerAdded(...) should have been called")));
                        return;
                    }
                    pipeline.fireUserEventTriggered(event);
                }
            });
            Assert.assertSame((Object)event, (Object)promise.syncUninterruptibly().getNow());
        }
        finally {
            pipeline1.channel().close().syncUninterruptibly();
            group.shutdownGracefully();
        }
    }

    @Test
    public void testNullName() {
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler()});
        pipeline.addLast(null, DefaultChannelPipelineTest.newHandler());
        pipeline.addFirst(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler()});
        pipeline.addFirst(null, DefaultChannelPipelineTest.newHandler());
        pipeline.addLast("test", DefaultChannelPipelineTest.newHandler());
        pipeline.addAfter("test", null, DefaultChannelPipelineTest.newHandler());
        pipeline.addBefore("test", null, DefaultChannelPipelineTest.newHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testUnorderedEventExecutor() throws Throwable {
        ChannelPipeline pipeline1 = new LocalChannel().pipeline();
        UnorderedThreadPoolEventExecutor eventExecutors = new UnorderedThreadPoolEventExecutor(2);
        DefaultEventLoopGroup defaultGroup = new DefaultEventLoopGroup(1);
        try {
            EventLoop eventLoop1 = defaultGroup.next();
            eventLoop1.register(pipeline1.channel()).syncUninterruptibly();
            final CountDownLatch latch = new CountDownLatch(1);
            pipeline1.addLast((EventExecutorGroup)eventExecutors, new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    LockSupport.park();
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    latch.countDown();
                }
            }});
            pipeline1.fireUserEventTriggered((Object)"");
            latch.await();
        }
        finally {
            defaultGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
            eventExecutors.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
        }
    }

    @Test
    public void testPinExecutor() {
        DefaultEventExecutorGroup group = new DefaultEventExecutorGroup(2);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        ChannelPipeline pipeline2 = new LocalChannel().pipeline();
        pipeline.addLast((EventExecutorGroup)group, "h1", (ChannelHandler)new ChannelInboundHandlerAdapter());
        pipeline.addLast((EventExecutorGroup)group, "h2", (ChannelHandler)new ChannelInboundHandlerAdapter());
        pipeline2.addLast((EventExecutorGroup)group, "h3", (ChannelHandler)new ChannelInboundHandlerAdapter());
        EventExecutor executor1 = pipeline.context("h1").executor();
        EventExecutor executor2 = pipeline.context("h2").executor();
        Assert.assertNotNull((Object)executor1);
        Assert.assertNotNull((Object)executor2);
        Assert.assertSame((Object)executor1, (Object)executor2);
        EventExecutor executor3 = pipeline2.context("h3").executor();
        Assert.assertNotNull((Object)executor3);
        Assert.assertNotSame((Object)executor3, (Object)executor2);
        group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    @Test
    public void testNotPinExecutor() {
        DefaultEventExecutorGroup group = new DefaultEventExecutorGroup(2);
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        pipeline.channel().config().setOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP, (Object)false);
        pipeline.addLast((EventExecutorGroup)group, "h1", (ChannelHandler)new ChannelInboundHandlerAdapter());
        pipeline.addLast((EventExecutorGroup)group, "h2", (ChannelHandler)new ChannelInboundHandlerAdapter());
        EventExecutor executor1 = pipeline.context("h1").executor();
        EventExecutor executor2 = pipeline.context("h2").executor();
        Assert.assertNotNull((Object)executor1);
        Assert.assertNotNull((Object)executor2);
        Assert.assertNotSame((Object)executor1, (Object)executor2);
        group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testVoidPromiseNotify() throws Throwable {
        ChannelPipeline pipeline1 = new LocalChannel().pipeline();
        DefaultEventLoopGroup defaultGroup = new DefaultEventLoopGroup(1);
        EventLoop eventLoop1 = defaultGroup.next();
        final Promise promise = eventLoop1.newPromise();
        final IllegalArgumentException exception = new IllegalArgumentException();
        try {
            eventLoop1.register(pipeline1.channel()).syncUninterruptibly();
            pipeline1.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
                    throw exception;
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    promise.setSuccess((Object)cause);
                }
            }});
            pipeline1.write((Object)"test", pipeline1.voidPromise());
            Assert.assertSame((Object)exception, (Object)promise.syncUninterruptibly().getNow());
        }
        finally {
            pipeline1.channel().close().syncUninterruptibly();
            defaultGroup.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandlerRemovedOnlyCalledWhenHandlerAddedCalled() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            final AtomicReference errorRef = new AtomicReference();
            for (int i = 0; i < 500; ++i) {
                ChannelPipeline pipeline = new LocalChannel().pipeline();
                group.register(pipeline.channel()).sync();
                final CountDownLatch latch = new CountDownLatch(1);
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                        latch.await(50L, TimeUnit.MILLISECONDS);
                    }
                }});
                pipeline.close();
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                    private boolean handerAddedCalled;

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        this.handerAddedCalled = true;
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) {
                        if (!this.handerAddedCalled) {
                            errorRef.set(new AssertionError((Object)"handlerRemoved(...) called without handlerAdded(...) before"));
                        }
                    }
                }});
                latch.countDown();
                pipeline.channel().closeFuture().syncUninterruptibly();
                pipeline.channel().eventLoop().submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).syncUninterruptibly();
                Error error = (Error)errorRef.get();
                if (error == null) continue;
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testSkipHandlerMethodsIfAnnotated() {
        EmbeddedChannel channel = new EmbeddedChannel(true, new ChannelHandler[0]);
        ChannelPipeline pipeline = channel.pipeline();
        final class OutboundCalledHandler
        extends ChannelOutboundHandlerAdapter {
            private static final int MASK_BIND = 1;
            private static final int MASK_CONNECT = 2;
            private static final int MASK_DISCONNECT = 4;
            private static final int MASK_CLOSE = 8;
            private static final int MASK_DEREGISTER = 16;
            private static final int MASK_READ = 32;
            private static final int MASK_WRITE = 64;
            private static final int MASK_FLUSH = 128;
            private static final int MASK_ADDED = 256;
            private static final int MASK_REMOVED = 512;
            private int executionMask;

            OutboundCalledHandler() {
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                this.executionMask |= 0x100;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                this.executionMask |= 0x200;
            }

            public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
                this.executionMask |= 1;
                promise.setSuccess();
            }

            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                this.executionMask |= 2;
                promise.setSuccess();
            }

            public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.executionMask |= 4;
                promise.setSuccess();
            }

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.executionMask |= 8;
                promise.setSuccess();
            }

            public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.executionMask |= 0x10;
                promise.setSuccess();
            }

            public void read(ChannelHandlerContext ctx) {
                this.executionMask |= 0x20;
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                this.executionMask |= 0x40;
                promise.setSuccess();
            }

            public void flush(ChannelHandlerContext ctx) {
                this.executionMask |= 0x80;
            }

            void assertCalled() {
                this.assertCalled("handlerAdded", 256);
                this.assertCalled("handlerRemoved", 512);
                this.assertCalled("bind", 1);
                this.assertCalled("connect", 2);
                this.assertCalled("disconnect", 4);
                this.assertCalled("close", 8);
                this.assertCalled("deregister", 16);
                this.assertCalled("read", 32);
                this.assertCalled("write", 64);
                this.assertCalled("flush", 128);
            }

            private void assertCalled(String methodName, int mask) {
                Assert.assertTrue((String)(methodName + " was not called"), ((this.executionMask & mask) != 0 ? 1 : 0) != 0);
            }
        }
        OutboundCalledHandler outboundCalledHandler = new OutboundCalledHandler();
        final class SkipHandler
        implements ChannelInboundHandler,
        ChannelOutboundHandler {
            private int state = 2;
            private Error errorRef;

            SkipHandler() {
            }

            private void fail() {
                this.errorRef = new AssertionError((Object)"Method should never been called");
            }

            @ChannelHandlerMask.Skip
            public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
                this.fail();
                ctx.bind(localAddress, promise);
            }

            @ChannelHandlerMask.Skip
            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                this.fail();
                ctx.connect(remoteAddress, localAddress, promise);
            }

            @ChannelHandlerMask.Skip
            public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.fail();
                ctx.disconnect(promise);
            }

            @ChannelHandlerMask.Skip
            public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.fail();
                ctx.close(promise);
            }

            @ChannelHandlerMask.Skip
            public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
                this.fail();
                ctx.deregister(promise);
            }

            @ChannelHandlerMask.Skip
            public void read(ChannelHandlerContext ctx) {
                this.fail();
                ctx.read();
            }

            @ChannelHandlerMask.Skip
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                this.fail();
                ctx.write(msg, promise);
            }

            @ChannelHandlerMask.Skip
            public void flush(ChannelHandlerContext ctx) {
                this.fail();
                ctx.flush();
            }

            @ChannelHandlerMask.Skip
            public void channelRegistered(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelRegistered();
            }

            @ChannelHandlerMask.Skip
            public void channelUnregistered(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelUnregistered();
            }

            @ChannelHandlerMask.Skip
            public void channelActive(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelActive();
            }

            @ChannelHandlerMask.Skip
            public void channelInactive(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelInactive();
            }

            @ChannelHandlerMask.Skip
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.fail();
                ctx.fireChannelRead(msg);
            }

            @ChannelHandlerMask.Skip
            public void channelReadComplete(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelReadComplete();
            }

            @ChannelHandlerMask.Skip
            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                this.fail();
                ctx.fireUserEventTriggered(evt);
            }

            @ChannelHandlerMask.Skip
            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                this.fail();
                ctx.fireChannelWritabilityChanged();
            }

            @ChannelHandlerMask.Skip
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                this.fail();
                ctx.fireExceptionCaught(cause);
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                --this.state;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                --this.state;
            }

            void assertSkipped() {
                Assert.assertEquals((long)0L, (long)this.state);
                Error error = this.errorRef;
                if (error != null) {
                    throw error;
                }
            }
        }
        SkipHandler skipHandler = new SkipHandler();
        final class InboundCalledHandler
        extends ChannelInboundHandlerAdapter {
            private static final int MASK_CHANNEL_REGISTER = 1;
            private static final int MASK_CHANNEL_UNREGISTER = 2;
            private static final int MASK_CHANNEL_ACTIVE = 4;
            private static final int MASK_CHANNEL_INACTIVE = 8;
            private static final int MASK_CHANNEL_READ = 16;
            private static final int MASK_CHANNEL_READ_COMPLETE = 32;
            private static final int MASK_USER_EVENT_TRIGGERED = 64;
            private static final int MASK_CHANNEL_WRITABILITY_CHANGED = 128;
            private static final int MASK_EXCEPTION_CAUGHT = 256;
            private static final int MASK_ADDED = 512;
            private static final int MASK_REMOVED = 1024;
            private int executionMask;

            InboundCalledHandler() {
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                this.executionMask |= 0x200;
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                this.executionMask |= 0x400;
            }

            public void channelRegistered(ChannelHandlerContext ctx) {
                this.executionMask |= 1;
            }

            public void channelUnregistered(ChannelHandlerContext ctx) {
                this.executionMask |= 2;
            }

            public void channelActive(ChannelHandlerContext ctx) {
                this.executionMask |= 4;
            }

            public void channelInactive(ChannelHandlerContext ctx) {
                this.executionMask |= 8;
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.executionMask |= 0x10;
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                this.executionMask |= 0x20;
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                this.executionMask |= 0x40;
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                this.executionMask |= 0x80;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                this.executionMask |= 0x100;
            }

            void assertCalled() {
                this.assertCalled("handlerAdded", 512);
                this.assertCalled("handlerRemoved", 1024);
                this.assertCalled("channelRegistered", 1);
                this.assertCalled("channelUnregistered", 2);
                this.assertCalled("channelActive", 4);
                this.assertCalled("channelInactive", 8);
                this.assertCalled("channelRead", 16);
                this.assertCalled("channelReadComplete", 32);
                this.assertCalled("userEventTriggered", 64);
                this.assertCalled("channelWritabilityChanged", 128);
                this.assertCalled("exceptionCaught", 256);
            }

            private void assertCalled(String methodName, int mask) {
                Assert.assertTrue((String)(methodName + " was not called"), ((this.executionMask & mask) != 0 ? 1 : 0) != 0);
            }
        }
        InboundCalledHandler inboundCalledHandler = new InboundCalledHandler();
        pipeline.addLast(new ChannelHandler[]{outboundCalledHandler, skipHandler, inboundCalledHandler});
        pipeline.fireChannelRegistered();
        pipeline.fireChannelUnregistered();
        pipeline.fireChannelActive();
        pipeline.fireChannelInactive();
        pipeline.fireChannelRead((Object)"");
        pipeline.fireChannelReadComplete();
        pipeline.fireChannelWritabilityChanged();
        pipeline.fireUserEventTriggered((Object)"");
        pipeline.fireExceptionCaught((Throwable)new Exception());
        pipeline.deregister().syncUninterruptibly();
        pipeline.bind(new SocketAddress(){}).syncUninterruptibly();
        pipeline.connect(new SocketAddress(){}).syncUninterruptibly();
        pipeline.disconnect().syncUninterruptibly();
        pipeline.close().syncUninterruptibly();
        pipeline.write((Object)"");
        pipeline.flush();
        pipeline.read();
        pipeline.remove((ChannelHandler)outboundCalledHandler);
        pipeline.remove((ChannelHandler)inboundCalledHandler);
        pipeline.remove((ChannelHandler)skipHandler);
        Assert.assertFalse((boolean)channel.finish());
        outboundCalledHandler.assertCalled();
        inboundCalledHandler.assertCalled();
        skipHandler.assertSkipped();
    }

    @Test
    public void testWriteThrowsReleaseMessage() {
        this.testWriteThrowsReleaseMessage0(false);
    }

    @Test
    public void testWriteAndFlushThrowsReleaseMessage() {
        this.testWriteThrowsReleaseMessage0(true);
    }

    private void testWriteThrowsReleaseMessage0(boolean flush) {
        AbstractReferenceCounted referenceCounted = new AbstractReferenceCounted(){

            protected void deallocate() {
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        };
        Assert.assertEquals((long)1L, (long)referenceCounted.refCnt());
        LocalChannel channel = new LocalChannel();
        LocalChannel channel2 = new LocalChannel();
        group.register((Channel)channel).syncUninterruptibly();
        group.register((Channel)channel2).syncUninterruptibly();
        try {
            if (flush) {
                channel.writeAndFlush((Object)referenceCounted, channel2.newPromise());
            } else {
                channel.write((Object)referenceCounted, channel2.newPromise());
            }
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)referenceCounted.refCnt());
        channel.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
    }

    @Test(timeout=5000L)
    public void testHandlerAddedFailedButHandlerStillRemoved() throws InterruptedException {
        DefaultChannelPipelineTest.testHandlerAddedFailedButHandlerStillRemoved0(false);
    }

    @Test(timeout=5000L)
    public void testHandlerAddedFailedButHandlerStillRemovedWithLaterRegister() throws InterruptedException {
        DefaultChannelPipelineTest.testHandlerAddedFailedButHandlerStillRemoved0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandlerAddedFailedButHandlerStillRemoved0(boolean lateRegister) throws InterruptedException {
        DefaultEventExecutorGroup executorGroup = new DefaultEventExecutorGroup(16);
        int numHandlers = 32;
        try {
            int i;
            LocalChannel channel = new LocalChannel();
            channel.config().setOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP, (Object)false);
            if (!lateRegister) {
                group.register((Channel)channel).sync();
            }
            channel.pipeline().addFirst(new ChannelHandler[]{DefaultChannelPipelineTest.newHandler()});
            ArrayList<CountDownLatch> latchList = new ArrayList<CountDownLatch>(32);
            for (i = 0; i < 32; ++i) {
                CountDownLatch latch = new CountDownLatch(1);
                channel.pipeline().addFirst((EventExecutorGroup)executorGroup, "h" + i, (ChannelHandler)new BadChannelHandler(latch));
                latchList.add(latch);
            }
            if (lateRegister) {
                group.register((Channel)channel).sync();
            }
            for (i = 0; i < 32; ++i) {
                ((CountDownLatch)latchList.get(i)).await();
                Assert.assertNull((Object)channel.pipeline().get("h" + i));
            }
        }
        finally {
            executorGroup.shutdownGracefully();
        }
    }

    @Test(timeout=5000L)
    public void handlerAddedStateUpdatedBeforeHandlerAddedDoneForceEventLoop() throws InterruptedException {
        DefaultChannelPipelineTest.handlerAddedStateUpdatedBeforeHandlerAddedDone(true);
    }

    @Test(timeout=5000L)
    public void handlerAddedStateUpdatedBeforeHandlerAddedDoneOnCallingThread() throws InterruptedException {
        DefaultChannelPipelineTest.handlerAddedStateUpdatedBeforeHandlerAddedDone(false);
    }

    private static void handlerAddedStateUpdatedBeforeHandlerAddedDone(boolean executeInEventLoop) throws InterruptedException {
        final ChannelPipeline pipeline = new LocalChannel().pipeline();
        final Object userEvent = new Object();
        final Object writeObject = new Object();
        final CountDownLatch doneLatch = new CountDownLatch(1);
        group.register(pipeline.channel());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt == userEvent) {
                            ctx.write(writeObject);
                        }
                        ctx.fireUserEventTriggered(evt);
                    }
                }});
                pipeline.addFirst(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        ctx.fireUserEventTriggered(userEvent);
                    }

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                        if (msg == writeObject) {
                            doneLatch.countDown();
                        }
                        ctx.write(msg, promise);
                    }
                }});
            }
        };
        if (executeInEventLoop) {
            pipeline.channel().eventLoop().execute(r);
        } else {
            r.run();
        }
        doneLatch.await();
    }

    private static void assertHandler(CheckOrderHandler actual, CheckOrderHandler ... handlers) throws Throwable {
        for (CheckOrderHandler h : handlers) {
            if (h != actual) continue;
            actual.checkError();
            return;
        }
        Assert.fail((String)"handler was not one of the expected handlers");
    }

    private static int next(AbstractChannelHandlerContext ctx) {
        AbstractChannelHandlerContext next = ctx.next;
        if (next == null) {
            return Integer.MAX_VALUE;
        }
        return DefaultChannelPipelineTest.toInt(next.name());
    }

    private static int toInt(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static void verifyContextNumber(ChannelPipeline pipeline, int expectedNumber) {
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)pipeline.firstContext();
        int handlerNumber = 0;
        while (ctx != ((DefaultChannelPipeline)pipeline).tail) {
            ++handlerNumber;
            ctx = ctx.next;
        }
        Assert.assertEquals((long)expectedNumber, (long)handlerNumber);
    }

    private static ChannelHandler[] newHandlers(int num) {
        assert (num > 0);
        ChannelHandler[] handlers = new ChannelHandler[num];
        for (int i = 0; i < num; ++i) {
            handlers[i] = DefaultChannelPipelineTest.newHandler();
        }
        return handlers;
    }

    private static ChannelHandler newHandler() {
        return new TestHandler();
    }

    private static final class WrapperExecutor
    extends AbstractEventExecutor {
        private final ExecutorService wrapped = Executors.newSingleThreadExecutor();

        private WrapperExecutor() {
        }

        public boolean isShuttingDown() {
            return this.wrapped.isShutdown();
        }

        public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
            throw new IllegalStateException();
        }

        public Future<?> terminationFuture() {
            throw new IllegalStateException();
        }

        public void shutdown() {
            this.wrapped.shutdown();
        }

        public List<Runnable> shutdownNow() {
            return this.wrapped.shutdownNow();
        }

        public boolean isShutdown() {
            return this.wrapped.isShutdown();
        }

        public boolean isTerminated() {
            return this.wrapped.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.wrapped.awaitTermination(timeout, unit);
        }

        public EventExecutorGroup parent() {
            return null;
        }

        public boolean inEventLoop(Thread thread) {
            return false;
        }

        public void execute(Runnable command) {
            this.wrapped.execute(command);
        }
    }

    private static final class LifeCycleAwareTestHandler
    extends ChannelHandlerAdapter {
        private final String name;
        private boolean afterAdd;
        private boolean afterRemove;

        private LifeCycleAwareTestHandler(String name) {
            this.name = name;
        }

        public void validate(boolean afterAdd, boolean afterRemove) {
            Assert.assertEquals((String)this.name, (Object)afterAdd, (Object)this.afterAdd);
            Assert.assertEquals((String)this.name, (Object)afterRemove, (Object)this.afterRemove);
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.validate(false, false);
            this.afterAdd = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.validate(true, false);
            this.afterRemove = true;
        }
    }

    private static class BufferedTestHandler
    extends ChannelDuplexHandler {
        final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
        final Queue<Object> outboundBuffer = new ArrayDeque<Object>();

        private BufferedTestHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.outboundBuffer.add(msg);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.inboundBuffer.add(msg);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (!this.inboundBuffer.isEmpty()) {
                for (Object e : this.inboundBuffer) {
                    ctx.fireChannelRead(e);
                }
                ctx.fireChannelReadComplete();
            }
            if (!this.outboundBuffer.isEmpty()) {
                for (Object e : this.outboundBuffer) {
                    ctx.write(e);
                }
                ctx.flush();
            }
        }
    }

    @ChannelHandler.Sharable
    private static class TestHandler
    extends ChannelDuplexHandler {
        private TestHandler() {
        }
    }

    private static final class ErrorChannelHandler
    extends ChannelHandlerAdapter {
        private final AtomicReference<Throwable> error;

        ErrorChannelHandler(AtomicReference<Throwable> error) {
            this.error = error;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.error.set((Throwable)((Object)new AssertionError()));
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.error.set((Throwable)((Object)new AssertionError()));
        }
    }

    private static final class CheckEventExecutorHandler
    extends ChannelHandlerAdapter {
        final EventExecutor executor;
        final Promise<Void> addedPromise;
        final Promise<Void> removedPromise;

        CheckEventExecutorHandler(EventExecutor executor) {
            this.executor = executor;
            this.addedPromise = executor.newPromise();
            this.removedPromise = executor.newPromise();
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.assertExecutor(ctx, this.addedPromise);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.assertExecutor(ctx, this.removedPromise);
        }

        private void assertExecutor(ChannelHandlerContext ctx, Promise<Void> promise) {
            boolean same;
            try {
                same = this.executor == ctx.executor();
            }
            catch (Throwable cause) {
                promise.setFailure(cause);
                return;
            }
            if (same) {
                promise.setSuccess(null);
            } else {
                promise.setFailure((Throwable)((Object)new AssertionError((Object)"EventExecutor not the same")));
            }
        }
    }

    private static final class CheckOrderHandler
    extends ChannelHandlerAdapter {
        private final Queue<CheckOrderHandler> addedQueue;
        private final Queue<CheckOrderHandler> removedQueue;
        private final AtomicReference<Throwable> error = new AtomicReference();

        CheckOrderHandler(Queue<CheckOrderHandler> addedQueue, Queue<CheckOrderHandler> removedQueue) {
            this.addedQueue = addedQueue;
            this.removedQueue = removedQueue;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.addedQueue.add(this);
            this.checkExecutor(ctx);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.removedQueue.add(this);
            this.checkExecutor(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.error.set(cause);
        }

        void checkError() throws Throwable {
            Throwable cause = this.error.get();
            if (cause != null) {
                throw cause;
            }
        }

        private void checkExecutor(ChannelHandlerContext ctx) {
            if (!ctx.executor().inEventLoop()) {
                this.error.set((Throwable)((Object)new AssertionError()));
            }
        }
    }

    private static final class CheckExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final Throwable expected;
        private final Promise<Void> promise;

        CheckExceptionHandler(Throwable expected, Promise<Void> promise) {
            this.expected = expected;
            this.promise = promise;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof ChannelPipelineException && cause.getCause() == this.expected) {
                this.promise.setSuccess(null);
            } else {
                this.promise.setFailure((Throwable)((Object)new AssertionError((Object)"cause not the expected instance")));
            }
        }
    }

    private static final class CallbackCheckHandler
    extends ChannelHandlerAdapter {
        final Promise<Boolean> addedHandler = ImmediateEventExecutor.INSTANCE.newPromise();
        final Promise<Boolean> removedHandler = ImmediateEventExecutor.INSTANCE.newPromise();
        final AtomicReference<Throwable> error = new AtomicReference();

        private CallbackCheckHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            if (!this.addedHandler.trySuccess((Object)true)) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerAdded(...) called multiple times: " + ctx.name()))));
            } else if (this.removedHandler.getNow() == Boolean.TRUE) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called before handlerAdded(...): " + ctx.name()))));
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (!this.removedHandler.trySuccess((Object)true)) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called multiple times: " + ctx.name()))));
            } else if (this.addedHandler.getNow() == Boolean.FALSE) {
                this.error.set((Throwable)((Object)new AssertionError((Object)("handlerRemoved(...) called before handlerAdded(...): " + ctx.name()))));
            }
        }
    }

    private static final class TestTask
    implements Runnable {
        private final ChannelPipeline pipeline;
        private final CountDownLatch latch;

        TestTask(ChannelPipeline pipeline, CountDownLatch latch) {
            this.pipeline = pipeline;
            this.latch = latch;
        }

        @Override
        public void run() {
            this.pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            this.latch.countDown();
        }
    }

    private static final class BadChannelHandler
    extends ChannelHandlerAdapter {
        private final CountDownLatch latch;

        BadChannelHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            TimeUnit.MILLISECONDS.sleep(10L);
            throw new RuntimeException();
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.latch.countDown();
        }
    }

    private static final class StringInboundHandler
    extends ChannelInboundHandlerAdapter {
        boolean called;

        private StringInboundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.called = true;
            if (!(msg instanceof String)) {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

