/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.Recycler;
import java.net.InetSocketAddress;

final class NioDatagramChannelOutboundBuffer
extends ChannelOutboundBuffer {
    private static final Recycler<NioDatagramChannelOutboundBuffer> RECYCLER = new Recycler<NioDatagramChannelOutboundBuffer>(){

        protected NioDatagramChannelOutboundBuffer newObject(Recycler.Handle<NioDatagramChannelOutboundBuffer> handle) {
            return new NioDatagramChannelOutboundBuffer(handle);
        }
    };

    static NioDatagramChannelOutboundBuffer newInstance(NioDatagramChannel channel) {
        NioDatagramChannelOutboundBuffer buffer = (NioDatagramChannelOutboundBuffer)RECYCLER.get();
        buffer.channel = channel;
        return buffer;
    }

    private NioDatagramChannelOutboundBuffer(Recycler.Handle<NioDatagramChannelOutboundBuffer> handle) {
        super(handle);
    }

    @Override
    protected Object beforeAdd(Object msg) {
        DatagramPacket packet;
        ByteBuf content;
        if (msg instanceof DatagramPacket && (!(content = (ByteBuf)(packet = (DatagramPacket)msg).content()).isDirect() || content.nioBufferCount() != 1)) {
            ByteBuf direct = this.copyToDirectByteBuf(content);
            return new DatagramPacket(direct, (InetSocketAddress)packet.recipient(), (InetSocketAddress)packet.sender());
        }
        return msg;
    }
}

