/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.MessageBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.oio.AbstractOioChannel;
import java.io.IOException;

public abstract class AbstractOioMessageChannel
extends AbstractOioChannel {
    protected AbstractOioMessageChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        ChannelPipeline pipeline = this.pipeline();
        MessageBuf msgBuf = pipeline.inboundMessageBuffer();
        boolean closed = false;
        boolean read = false;
        boolean firedChannelReadSuspended = false;
        try {
            int localReadAmount = this.doReadMessages(msgBuf);
            if (localReadAmount > 0) {
                read = true;
            } else if (localReadAmount < 0) {
                closed = true;
            }
        }
        catch (Throwable t) {
            if (read) {
                read = false;
                pipeline.fireInboundBufferUpdated();
            }
            firedChannelReadSuspended = true;
            pipeline.fireChannelReadSuspended();
            pipeline.fireExceptionCaught(t);
            if (t instanceof IOException) {
                this.unsafe().close(this.voidPromise());
            }
        }
        finally {
            if (read) {
                pipeline.fireInboundBufferUpdated();
            }
            if (!firedChannelReadSuspended) {
                pipeline.fireChannelReadSuspended();
            }
            if (closed && this.isOpen()) {
                this.unsafe().close(this.voidPromise());
            }
        }
    }

    @Override
    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        while (!buf.isEmpty()) {
            this.doWriteMessages(buf);
        }
    }

    protected abstract int doReadMessages(MessageBuf<Object> var1) throws Exception;

    protected abstract void doWriteMessages(MessageBuf<Object> var1) throws Exception;
}

