/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopException;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.aio.AbstractAioChannel;
import io.netty.channel.aio.AioChannelFinder;
import io.netty.channel.aio.AioEventLoop;
import io.netty.channel.aio.ReflectiveAioChannelFinder;
import io.netty.channel.aio.UnsafeAioChannelFinder;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AioEventLoopGroup
extends MultithreadEventLoopGroup {
    private static final InternalLogger LOGGER;
    private static final AioChannelFinder CHANNEL_FINDER;
    private final AioExecutorService groupExecutor = new AioExecutorService();
    private final AsynchronousChannelGroup group;

    public AsynchronousChannelGroup channelGroup() {
        return this.group;
    }

    public AioEventLoopGroup() {
        this(0);
    }

    public AioEventLoopGroup(int nThreads) {
        this(nThreads, null);
    }

    public AioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        super(nThreads, threadFactory, new Object[0]);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(this.groupExecutor);
        }
        catch (IOException e) {
            throw new EventLoopException("Failed to create an AsynchronousChannelGroup", e);
        }
    }

    @Override
    public void shutdown() {
        boolean interrupted = false;
        try {
            this.group.shutdownNow();
        }
        catch (IOException e) {
            throw new EventLoopException("failed to shut down a channel group", e);
        }
        while (!this.groupExecutor.isTerminated()) {
            try {
                this.groupExecutor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        super.shutdown();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, ChannelTaskScheduler scheduler, Object ... args) throws Exception {
        return new AioEventLoop(this, threadFactory, scheduler);
    }

    static {
        AioChannelFinder finder;
        LOGGER = InternalLoggerFactory.getInstance(AioEventLoopGroup.class);
        try {
            finder = PlatformDependent.hasUnsafe() ? new UnsafeAioChannelFinder() : new ReflectiveAioChannelFinder();
        }
        catch (Throwable t) {
            LOGGER.debug(String.format("Failed to instantiate the optimal %s implementation - falling back to %s.", AioChannelFinder.class.getSimpleName(), ReflectiveAioChannelFinder.class.getSimpleName()), t);
            finder = new ReflectiveAioChannelFinder();
        }
        CHANNEL_FINDER = finder;
    }

    private final class AioExecutorService
    extends AbstractExecutorService {
        private final CountDownLatch latch = new CountDownLatch(1);

        private AioExecutorService() {
        }

        @Override
        public void shutdown() {
            this.latch.countDown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown();
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            Class<?> commandType = command.getClass();
            if (commandType.getName().startsWith("sun.nio.ch.")) {
                this.executeAioTask(command);
            } else {
                AioEventLoopGroup.this.next().execute(command);
            }
        }

        private void executeAioTask(Runnable command) {
            AbstractAioChannel ch = null;
            try {
                ch = CHANNEL_FINDER.findChannel(command);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EventLoop l = ch != null ? ch.eventLoop() : AioEventLoopGroup.this.next();
            if (l.isShutdown()) {
                command.run();
            } else {
                l.execute(command);
            }
        }
    }
}

