/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.aio.AioEventLoop;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAioChannel
extends AbstractChannel {
    protected volatile AsynchronousChannel ch;
    protected ChannelPromise connectPromise;
    protected ScheduledFuture<?> connectTimeoutFuture;
    private ConnectException connectTimeoutException;

    protected AbstractAioChannel(Channel parent, Integer id, AsynchronousChannel ch) {
        super(parent, id);
        this.ch = ch;
    }

    protected AsynchronousChannel javaChannel() {
        if (this.ch == null) {
            throw new IllegalStateException("Try to access Channel before eventLoop was registered");
        }
        return this.ch;
    }

    @Override
    public boolean isOpen() {
        if (this.ch == null) {
            return true;
        }
        return this.ch.isOpen();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof AioEventLoop;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultAioUnsafe();
    }

    protected abstract void doConnect(SocketAddress var1, SocketAddress var2, ChannelPromise var3);

    protected final class DefaultAioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        protected DefaultAioUnsafe() {
        }

        @Override
        public void connect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
            if (AbstractAioChannel.this.eventLoop().inEventLoop()) {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                try {
                    if (AbstractAioChannel.this.connectPromise != null) {
                        throw new IllegalStateException("connection attempt already made");
                    }
                    AbstractAioChannel.this.connectPromise = promise;
                    AbstractAioChannel.this.doConnect(remoteAddress, localAddress, promise);
                    int connectTimeoutMillis = AbstractAioChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        AbstractAioChannel.this.connectTimeoutFuture = AbstractAioChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise connectFuture;
                                if (AbstractAioChannel.this.connectTimeoutException == null) {
                                    AbstractAioChannel.this.connectTimeoutException = new ConnectException("connection timed out");
                                }
                                if ((connectFuture = AbstractAioChannel.this.connectPromise) != null && connectFuture.tryFailure(AbstractAioChannel.this.connectTimeoutException)) {
                                    AbstractAioChannel.this.pipeline().fireExceptionCaught(AbstractAioChannel.this.connectTimeoutException);
                                    DefaultAioUnsafe.this.close(DefaultAioUnsafe.this.voidFuture());
                                }
                            }
                        }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                    this.closeIfClosed();
                }
            } else {
                AbstractAioChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultAioUnsafe.this.connect(remoteAddress, localAddress, promise);
                    }
                });
            }
        }

        public void connectFailed(Throwable t) {
            AbstractAioChannel.this.connectPromise.setFailure(t);
            AbstractAioChannel.this.pipeline().fireExceptionCaught(t);
            this.closeIfClosed();
        }

        public void connectSuccess() {
            assert (AbstractAioChannel.this.eventLoop().inEventLoop());
            assert (AbstractAioChannel.this.connectPromise != null);
            try {
                boolean wasActive = AbstractAioChannel.this.isActive();
                AbstractAioChannel.this.connectPromise.setSuccess();
                if (!wasActive && AbstractAioChannel.this.isActive()) {
                    AbstractAioChannel.this.pipeline().fireChannelActive();
                }
            }
            catch (Throwable t) {
                AbstractAioChannel.this.connectPromise.setFailure(t);
                this.closeIfClosed();
            }
            finally {
                AbstractAioChannel.this.connectTimeoutFuture.cancel(false);
                AbstractAioChannel.this.connectPromise = null;
            }
        }
    }
}

