/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundByteHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelStateHandler;
import io.netty.channel.FileRegion;
import java.net.SocketAddress;

public class CombinedChannelDuplexHandler
extends ChannelDuplexHandler {
    private ChannelStateHandler stateHandler;
    private ChannelOperationHandler operationHandler;

    protected CombinedChannelDuplexHandler() {
    }

    public CombinedChannelDuplexHandler(ChannelStateHandler stateHandler, ChannelOperationHandler operationHandler) {
        this.init(stateHandler, operationHandler);
    }

    protected final void init(ChannelStateHandler stateHandler, ChannelOperationHandler operationHandler) {
        this.validate(stateHandler, operationHandler);
        this.stateHandler = stateHandler;
        this.operationHandler = operationHandler;
    }

    private void validate(ChannelStateHandler stateHandler, ChannelOperationHandler operationHandler) {
        if (this.stateHandler != null) {
            throw new IllegalStateException("init() can not be invoked if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with non-default constructor.");
        }
        if (stateHandler == null) {
            throw new NullPointerException("stateHandler");
        }
        if (operationHandler == null) {
            throw new NullPointerException("operationHandler");
        }
        if (stateHandler instanceof ChannelOperationHandler) {
            throw new IllegalArgumentException("stateHandler must not implement " + ChannelOperationHandler.class.getSimpleName() + " to get combined.");
        }
        if (operationHandler instanceof ChannelStateHandler) {
            throw new IllegalArgumentException("operationHandler must not implement " + ChannelStateHandler.class.getSimpleName() + " to get combined.");
        }
        if (stateHandler instanceof ChannelInboundByteHandler && !(this instanceof ChannelInboundByteHandler)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " must implement " + ChannelInboundByteHandler.class.getSimpleName() + " if stateHandler implements " + ChannelInboundByteHandler.class.getSimpleName());
        }
        if (stateHandler instanceof ChannelInboundMessageHandler && !(this instanceof ChannelInboundMessageHandler)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " must implement " + ChannelInboundMessageHandler.class.getSimpleName() + " if stateHandler implements " + ChannelInboundMessageHandler.class.getSimpleName());
        }
        if (operationHandler instanceof ChannelOutboundByteHandler && !(this instanceof ChannelOutboundByteHandler)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " must implement " + ChannelOutboundByteHandler.class.getSimpleName() + " if operationHandler implements " + ChannelOutboundByteHandler.class.getSimpleName());
        }
        if (operationHandler instanceof ChannelOutboundMessageHandler && !(this instanceof ChannelOutboundMessageHandler)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " must implement " + ChannelOutboundMessageHandler.class.getSimpleName() + " if operationHandler implements " + ChannelOutboundMessageHandler.class.getSimpleName());
        }
    }

    protected final ChannelStateHandler stateHandler() {
        return this.stateHandler;
    }

    protected final ChannelOperationHandler operationHandler() {
        return this.operationHandler;
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        if (this.stateHandler == null) {
            throw new IllegalStateException("init() must be invoked before being added to a " + ChannelPipeline.class.getSimpleName() + " if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with the default constructor.");
        }
        try {
            this.stateHandler.beforeAdd(ctx);
        }
        finally {
            this.operationHandler.beforeAdd(ctx);
        }
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        try {
            this.stateHandler.afterAdd(ctx);
        }
        finally {
            this.operationHandler.afterAdd(ctx);
        }
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        try {
            this.stateHandler.beforeRemove(ctx);
        }
        finally {
            this.operationHandler.beforeRemove(ctx);
        }
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        try {
            this.stateHandler.afterRemove(ctx);
        }
        finally {
            this.operationHandler.afterRemove(ctx);
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.stateHandler.channelRegistered(ctx);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.stateHandler.channelUnregistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.stateHandler.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.stateHandler.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.stateHandler.exceptionCaught(ctx, cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.stateHandler.userEventTriggered(ctx, evt);
    }

    @Override
    public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        this.stateHandler.inboundBufferUpdated(ctx);
        if (this.stateHandler instanceof ChannelInboundByteHandler) {
            ((ChannelInboundByteHandler)this.stateHandler).discardInboundReadBytes(ctx);
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.operationHandler.bind(ctx, localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.operationHandler.connect(ctx, remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.operationHandler.disconnect(ctx, promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.operationHandler.close(ctx, promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.operationHandler.deregister(ctx, promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) {
        this.operationHandler.read(ctx);
    }

    @Override
    public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.operationHandler.flush(ctx, promise);
    }

    @Override
    public void sendFile(ChannelHandlerContext ctx, FileRegion region, ChannelPromise promise) throws Exception {
        this.operationHandler.sendFile(ctx, region, promise);
    }
}

