/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;

final class SelectorUtil {
    private static final InternalLogger logger;
    static final long DEFAULT_SELECT_TIMEOUT = 10L;
    static final long SELECT_TIMEOUT;
    static final long SELECT_TIMEOUT_NANOS;

    static int select(Selector selector) throws IOException {
        try {
            return selector.select(SELECT_TIMEOUT);
        }
        catch (CancelledKeyException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", (Throwable)e);
            }
            return -1;
        }
    }

    static void cleanupKeys(Selector selector) {
        try {
            selector.selectNow();
        }
        catch (Throwable t) {
            logger.warn("Failed to update SelectionKeys.", t);
        }
    }

    private SelectorUtil() {
    }

    static {
        long selectTimeout;
        block5: {
            logger = InternalLoggerFactory.getInstance(SelectorUtil.class);
            String key = "sun.nio.ch.bugLevel";
            try {
                String buglevel = System.getProperty(key);
                if (buglevel == null) {
                    System.setProperty(key, "");
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Unable to get/set System Property '" + key + "'", (Throwable)e);
            }
        }
        try {
            selectTimeout = Long.parseLong(System.getProperty("io.netty.selectTimeout", String.valueOf(10L)));
        }
        catch (NumberFormatException e) {
            selectTimeout = 10L;
        }
        SELECT_TIMEOUT = selectTimeout;
        SELECT_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(SELECT_TIMEOUT);
        logger.debug("Using select timeout of " + SELECT_TIMEOUT);
    }
}

