/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;

abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    protected AbstractNioByteChannel(Channel parent, Integer id, SelectableChannel ch) {
        super(parent, id, ch, 1);
    }

    @Override
    protected abstract AbstractNioByteUnsafe newUnsafe();

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        int localFlushedAmount;
        if (!buf.readable()) {
            buf.clear();
            return;
        }
        for (int i = this.config().getWriteSpinCount() - 1; i >= 0 && (localFlushedAmount = this.doWriteBytes(buf, i == 0)) <= 0; --i) {
            if (buf.readable()) continue;
            buf.clear();
            break;
        }
    }

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1, boolean var2) throws Exception;

    private static int expandReadBuffer(ByteBuf byteBuf) {
        int writerIndex = byteBuf.writerIndex();
        int capacity = byteBuf.capacity();
        if (capacity != writerIndex) {
            return 0;
        }
        int maxCapacity = byteBuf.maxCapacity();
        if (capacity == maxCapacity) {
            return 2;
        }
        int increment = 4096;
        if (writerIndex + 4096 > maxCapacity) {
            byteBuf.capacity(maxCapacity);
        } else {
            byteBuf.ensureWritableBytes(4096);
        }
        return 1;
    }

    abstract class AbstractNioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        AbstractNioByteUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void read() {
            assert (AbstractNioByteChannel.this.eventLoop().inEventLoop());
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            try {
                AbstractNioByteChannel.expandReadBuffer(byteBuf);
                while (true) {
                    int localReadAmount;
                    if ((localReadAmount = AbstractNioByteChannel.this.doReadBytes(byteBuf)) > 0) {
                        read = true;
                    } else if (localReadAmount < 0) {
                        closed = true;
                        return;
                    }
                    switch (AbstractNioByteChannel.expandReadBuffer(byteBuf)) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (!read) break;
                            read = false;
                            pipeline.fireInboundBufferUpdated();
                            if (byteBuf.writable()) break;
                            throw new IllegalStateException("an inbound handler whose buffer is full must consume at least one byte.");
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                AbstractNioByteChannel.this.pipeline().fireExceptionCaught(t);
                if (!(t instanceof IOException)) return;
                this.close(this.voidFuture());
                return;
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed && AbstractNioByteChannel.this.isOpen()) {
                    this.close(this.voidFuture());
                }
            }
        }
    }
}

