/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopException;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.aio.AbstractAioChannel;
import io.netty.channel.socket.aio.AioEventLoop;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AioEventLoopGroup
extends MultithreadEventLoopGroup {
    private static final ConcurrentMap<Class<?>, Field[]> fieldCache = new ConcurrentHashMap();
    private static final Field[] FAILURE = new Field[0];
    final AsynchronousChannelGroup group;

    public AioEventLoopGroup() {
        this(0);
    }

    public AioEventLoopGroup(int nThreads) {
        this(nThreads, null);
    }

    public AioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        super(nThreads, threadFactory, new Object[0]);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(new AioExecutorService());
        }
        catch (IOException e) {
            throw new EventLoopException("Failed to create an AsynchronousChannelGroup", e);
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, ChannelTaskScheduler scheduler, Object ... args) throws Exception {
        return new AioEventLoop(this, threadFactory, scheduler);
    }

    private void executeAioTask(Runnable command) {
        AbstractAioChannel ch = null;
        try {
            ch = AioEventLoopGroup.findChannel(command);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventLoop l = ch != null ? ch.eventLoop() : this.next();
        if (l.isShutdown()) {
            command.run();
        } else {
            l.execute(command);
        }
    }

    private static AbstractAioChannel findChannel(Runnable command) throws Exception {
        Class<?> commandType = command.getClass();
        Field[] fields = (Field[])fieldCache.get(commandType);
        if (fields == null) {
            try {
                fields = AioEventLoopGroup.findFieldSequence(command, new ArrayDeque<Field>(2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fields == null) {
                fields = FAILURE;
            }
            fieldCache.put(commandType, fields);
        }
        if (fields == FAILURE) {
            return null;
        }
        int lastIndex = fields.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            command = (Runnable)fields[i].get(command);
        }
        return (AbstractAioChannel)fields[lastIndex].get(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field[] findFieldSequence(Runnable command, Deque<Field> fields) throws Exception {
        Class<?> commandType = command.getClass();
        for (Field f : commandType.getDeclaredFields()) {
            if (f.getType() == Runnable.class) {
                f.setAccessible(true);
                fields.addLast(f);
                try {
                    Field[] ret = AioEventLoopGroup.findFieldSequence((Runnable)f.get(command), fields);
                    if (ret != null) {
                        Field[] fieldArray = ret;
                        return fieldArray;
                    }
                }
                finally {
                    fields.removeLast();
                }
            }
            if (f.getType() != Object.class) continue;
            f.setAccessible(true);
            fields.addLast(f);
            try {
                Object candidate = f.get(command);
                if (!(candidate instanceof AbstractAioChannel)) continue;
                Field[] fieldArray = fields.toArray(new Field[fields.size()]);
                return fieldArray;
            }
            finally {
                fields.removeLast();
            }
        }
        return null;
    }

    private final class AioExecutorService
    extends AbstractExecutorService {
        private AioExecutorService() {
        }

        @Override
        public void shutdown() {
            AioEventLoopGroup.this.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            AioEventLoopGroup.this.shutdown();
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return AioEventLoopGroup.this.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return AioEventLoopGroup.this.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return AioEventLoopGroup.this.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            Class<?> commandType = command.getClass();
            if (commandType.getName().startsWith("sun.nio.ch.")) {
                AioEventLoopGroup.this.executeAioTask(command);
            } else {
                AioEventLoopGroup.this.next().execute(command);
            }
        }
    }
}

