/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInboundMessageHandler;

public abstract class ChannelInboundMessageHandlerAdapter<I>
extends ChannelInboundHandlerAdapter
implements ChannelInboundMessageHandler<I> {
    @Override
    public MessageBuf<I> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public final void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        Object msg;
        MessageBuf in = ctx.inboundMessageBuffer();
        while ((msg = in.poll()) != null) {
            try {
                this.messageReceived(ctx, msg);
            }
            catch (Throwable t) {
                ctx.fireExceptionCaught(t);
            }
        }
    }

    public abstract void messageReceived(ChannelHandlerContext var1, I var2) throws Exception;
}

