/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;

abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    protected AbstractNioByteChannel(Channel parent, Integer id, SelectableChannel ch) {
        super(parent, id, ch, 1);
    }

    @Override
    protected Channel.Unsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        int localFlushedAmount;
        if (!buf.readable()) {
            buf.clear();
            return;
        }
        for (int i = this.config().getWriteSpinCount() - 1; i >= 0 && (localFlushedAmount = this.doWriteBytes(buf, i == 0)) <= 0; --i) {
            if (buf.readable()) continue;
            buf.clear();
            break;
        }
    }

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1, boolean var2) throws Exception;

    private static boolean expandReadBuffer(ByteBuf byteBuf) {
        if (!byteBuf.writable()) {
            byteBuf.ensureWritableBytes(4096);
            return true;
        }
        return false;
    }

    private class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private NioByteUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            assert (AbstractNioByteChannel.this.eventLoop().inEventLoop());
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            try {
                AbstractNioByteChannel.expandReadBuffer(byteBuf);
                do {
                    int localReadAmount;
                    if ((localReadAmount = AbstractNioByteChannel.this.doReadBytes(byteBuf)) > 0) {
                        read = true;
                        continue;
                    }
                    if (localReadAmount >= 0) continue;
                    closed = true;
                    break;
                } while (AbstractNioByteChannel.expandReadBuffer(byteBuf));
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                AbstractNioByteChannel.this.pipeline().fireExceptionCaught(t);
                if (t instanceof IOException) {
                    this.close(this.voidFuture());
                }
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed && AbstractNioByteChannel.this.isOpen()) {
                    this.close(this.voidFuture());
                }
            }
        }
    }
}

