/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.ServerChannel;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.NetworkConstants;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private static final InetSocketAddress DEFAULT_LOCAL_ADDR = new InetSocketAddress(NetworkConstants.LOCALHOST, 0);
    private final ChannelHandler acceptor = new ChannelInitializer<Channel>(){

        @Override
        public void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast(new Acceptor());
        }
    };
    private final Map<ChannelOption<?>, Object> parentOptions = new LinkedHashMap();
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private EventLoop parentEventLoop;
    private EventLoop childEventLoop;
    private ServerChannel channel;
    private ChannelHandler handler;
    private ChannelHandler childHandler;
    private SocketAddress localAddress;

    public ServerBootstrap eventLoop(EventLoop parentEventLoop, EventLoop childEventLoop) {
        if (parentEventLoop == null) {
            throw new NullPointerException("parentEventLoop");
        }
        if (this.parentEventLoop != null) {
            throw new IllegalStateException("eventLoop set already");
        }
        this.parentEventLoop = parentEventLoop;
        this.childEventLoop = childEventLoop;
        return this;
    }

    public ServerBootstrap channel(ServerChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (this.channel != null) {
            throw new IllegalStateException("channel set already");
        }
        this.channel = channel;
        return this;
    }

    public <T> ServerBootstrap option(ChannelOption<T> parentOption, T value) {
        if (parentOption == null) {
            throw new NullPointerException("parentOption");
        }
        if (value == null) {
            this.parentOptions.remove(parentOption);
        } else {
            this.parentOptions.put(parentOption, value);
        }
        return this;
    }

    public <T> ServerBootstrap childOption(ChannelOption<T> childOption, T value) {
        if (childOption == null) {
            throw new NullPointerException("childOption");
        }
        if (value == null) {
            this.childOptions.remove(childOption);
        } else {
            this.childOptions.put(childOption, value);
        }
        return this;
    }

    public ServerBootstrap handler(ChannelHandler handler) {
        this.handler = handler;
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler childHandler) {
        if (childHandler == null) {
            throw new NullPointerException("childHandler");
        }
        this.childHandler = childHandler;
        return this;
    }

    public ServerBootstrap localAddress(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.localAddress = localAddress;
        return this;
    }

    public ServerBootstrap localAddress(int port) {
        this.localAddress = new InetSocketAddress(port);
        return this;
    }

    public ServerBootstrap localAddress(String host, int port) {
        this.localAddress = new InetSocketAddress(host, port);
        return this;
    }

    public ServerBootstrap localAddress(InetAddress host, int port) {
        this.localAddress = new InetSocketAddress(host, port);
        return this;
    }

    public ChannelFuture bind() {
        this.validate();
        return this.bind(this.channel.newFuture());
    }

    public ChannelFuture bind(ChannelFuture future) {
        this.validate(future);
        if (this.channel.isActive()) {
            future.setFailure(new IllegalStateException("channel already bound: " + this.channel));
            return future;
        }
        if (this.channel.isRegistered()) {
            future.setFailure(new IllegalStateException("channel already registered: " + this.channel));
            return future;
        }
        if (!this.channel.isOpen()) {
            future.setFailure(new ClosedChannelException());
            return future;
        }
        try {
            this.channel.config().setOptions(this.parentOptions);
        }
        catch (Exception e) {
            future.setFailure(e);
            return future;
        }
        ChannelPipeline p = this.channel.pipeline();
        if (this.handler != null) {
            p.addLast(this.handler);
        }
        p.addLast(this.acceptor);
        ChannelFuture f = this.parentEventLoop.register(this.channel).awaitUninterruptibly();
        if (!f.isSuccess()) {
            future.setFailure(f.cause());
            return future;
        }
        if (!this.channel.isOpen()) {
            future.setFailure(new ChannelException("initialization failure"));
            return future;
        }
        this.channel.bind(this.localAddress, future).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        return future;
    }

    public void shutdown() {
        if (this.parentEventLoop != null) {
            this.parentEventLoop.shutdown();
        }
        if (this.childEventLoop != null) {
            this.childEventLoop.shutdown();
        }
    }

    private void validate() {
        if (this.parentEventLoop == null) {
            throw new IllegalStateException("eventLoop not set");
        }
        if (this.channel == null) {
            throw new IllegalStateException("channel not set");
        }
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childEventLoop == null) {
            logger.warn("childEventLoop is not set. Using eventLoop instead.");
            this.childEventLoop = this.parentEventLoop;
        }
        if (this.localAddress == null) {
            logger.warn("localAddress is not set. Using " + DEFAULT_LOCAL_ADDR + " instead.");
            this.localAddress = DEFAULT_LOCAL_ADDR;
        }
    }

    private void validate(ChannelFuture future) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (future.channel() != this.channel) {
            throw new IllegalArgumentException("future.channel() must be the same channel.");
        }
        this.validate();
    }

    private class Acceptor
    extends ChannelInboundHandlerAdapter
    implements ChannelInboundMessageHandler<Channel> {
        private Acceptor() {
        }

        @Override
        public MessageBuf<Channel> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            return Unpooled.messageBuffer();
        }

        @Override
        public void inboundBufferUpdated(ChannelHandlerContext ctx) {
            Channel child;
            MessageBuf in = ctx.inboundMessageBuffer();
            while ((child = (Channel)in.poll()) != null) {
                child.pipeline().addLast(ServerBootstrap.this.childHandler);
                for (Map.Entry e : ServerBootstrap.this.childOptions.entrySet()) {
                    try {
                        if (child.config().setOption((ChannelOption)((Object)e.getKey()), e.getValue())) continue;
                        logger.warn("Unknown channel option: " + e);
                    }
                    catch (Throwable t) {
                        logger.warn("Failed to set a channel option: " + child, t);
                    }
                }
                try {
                    ServerBootstrap.this.childEventLoop.register(child);
                }
                catch (Throwable t) {
                    logger.warn("Failed to register an accepted channel: " + child, t);
                }
            }
        }
    }
}

