/*
 * Copyright 2013 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.netty.test.udt.nio;

import io.netty.test.udt.util.UnitHelp;
import org.junit.BeforeClass;

import static org.junit.Assume.*;

/**
 * Base for UDT tests.
 */
public abstract class AbstractUdtTest {

    /**
     * UDT test assumptions.
     */
    @BeforeClass
    public static void assumeConditions() {
        assumeTrue(UnitHelp.canLoadAndInitClass("com.barchart.udt.SocketUDT"));
    }

}
