/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import io.netty.test.udt.util.UnitHelp;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class TrafficControl {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(TrafficControl.class);
    private static final String TC_DELAY = "sudo tc qdisc add dev %s root netem delay %sms limit %s";
    private static final String TC_RESET = "sudo tc qdisc del dev %s root";

    private TrafficControl() {
    }

    public static boolean isAvailable() {
        try {
            int millis = 100;
            int margin = 20;
            TrafficControl.delay(0);
            long time1 = UnitHelp.ping("localhost");
            TrafficControl.delay(100);
            long time2 = UnitHelp.ping("localhost");
            TrafficControl.delay(0);
            long time3 = UnitHelp.ping("localhost");
            return time2 >= time1 + 100L - 20L && time2 >= time3 + 100L - 20L;
        }
        catch (Throwable e) {
            log.debug("", e);
            return false;
        }
    }

    public static void delay(int time) throws Exception {
        if (time < 0) {
            throw new IllegalArgumentException("negative latency");
        }
        int delay = time / 2;
        if (delay == 0) {
            UnitHelp.process(String.format(TC_RESET, "lo"));
        } else {
            int limit = 0x100000;
            UnitHelp.process(String.format(TC_RESET, "lo"));
            UnitHelp.process(String.format(TC_DELAY, "lo", delay, 0x100000));
        }
    }
}

