/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.google.caliper.Measurement;
import com.google.caliper.MeasurementSet;
import com.google.caliper.Run;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CaliperMeasure {
    private static final Map<String, Integer> RATE_UNIT = new HashMap<String, Integer>();
    private static final Map<String, Integer> TIME_UNIT;
    private static final Map<String, Integer> SIZE_UNIT;
    private final Map<Long, Measurement> rateMap = new HashMap<Long, Measurement>();
    private final Map<Long, Measurement> timeMap = new HashMap<Long, Measurement>();
    private final Map<Long, Measurement> sizeMap = new HashMap<Long, Measurement>();
    private final MetricsRegistry metrics = new MetricsRegistry();
    private final Meter rate = this.metrics.newMeter(this.getClass(), "rate", "bytes", TimeUnit.SECONDS);
    private final Timer time = this.metrics.newTimer(this.getClass(), "time", TimeUnit.NANOSECONDS, TimeUnit.SECONDS);
    private final SizeGuage size = new SizeGuage();
    private final Map<String, String> variables;

    public CaliperMeasure() {
        this.metrics.newGauge(this.getClass(), "", (Gauge)this.size);
        this.variables = new HashMap<String, String>();
    }

    public Meter rate() {
        return this.rate;
    }

    public Timer time() {
        return this.time;
    }

    public SizeGuage size() {
        return this.size;
    }

    private static double filter(double value) {
        if (value <= 0.0) {
            return 1.0;
        }
        return value;
    }

    public void mark() {
        double rateValue = CaliperMeasure.filter(this.rate.oneMinuteRate());
        double timeValue = CaliperMeasure.filter(this.time.mean());
        double sizeValue = CaliperMeasure.filter(this.size.value());
        if (rateValue == 1.0 && timeValue == 1.0 && sizeValue == 1.0) {
            return;
        }
        Measurement markRate = new Measurement(RATE_UNIT, rateValue, rateValue);
        this.rateMap.put(System.nanoTime(), markRate);
        Measurement markTime = new Measurement(TIME_UNIT, timeValue, timeValue);
        this.timeMap.put(System.nanoTime(), markTime);
        Measurement markSize = new Measurement(SIZE_UNIT, sizeValue, sizeValue);
        this.sizeMap.put(System.nanoTime(), markSize);
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    private static MeasurementSet measurementSet(Map<Long, Measurement> map) {
        Measurement[] array = map.values().toArray(new Measurement[map.size()]);
        MeasurementSet set = new MeasurementSet(array);
        return set;
    }

    public void appendTo(Run run) {
        Scenario scenario = new Scenario(this.variables());
        MeasurementSet timeSet = CaliperMeasure.measurementSet(this.rateMap);
        String timeLog = null;
        MeasurementSet instSet = CaliperMeasure.measurementSet(this.timeMap);
        String instLog = null;
        MeasurementSet heapSet = CaliperMeasure.measurementSet(this.sizeMap);
        String heapLog = null;
        ScenarioResult scenarioResult = new ScenarioResult(timeSet, timeLog, instSet, instLog, heapSet, heapLog);
        Map measurements = run.getMeasurements();
        measurements.put(scenario, scenarioResult);
    }

    public void shutdown() {
        this.rate.stop();
        this.time.stop();
        this.metrics.shutdown();
    }

    static {
        RATE_UNIT.put("Rate  B/s", 1);
        RATE_UNIT.put("Rate KB/s", 1024);
        RATE_UNIT.put("Rate MB/s", 0x100000);
        RATE_UNIT.put("Rate GB/s", 0x40000000);
        TIME_UNIT = new HashMap<String, Integer>();
        TIME_UNIT.put("Time ns", 1);
        TIME_UNIT.put("Time us", 1000);
        TIME_UNIT.put("Time ms", 1000000);
        TIME_UNIT.put("Time s ", 1000000000);
        SIZE_UNIT = new HashMap<String, Integer>();
        SIZE_UNIT.put("Size  B", 1);
        SIZE_UNIT.put("Size KB", 1024);
        SIZE_UNIT.put("Size MB", 0x100000);
        SIZE_UNIT.put("Size GB", 0x40000000);
    }

    public static class SizeGuage
    extends Gauge<Double> {
        private volatile Double size = 0.0;

        public Double value() {
            return this.size;
        }

        public void value(double size) {
            this.size = size;
        }
    }
}

