/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class EchoMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EchoMessageHandler.class);
    private final Meter meter;
    private final UdtMessage message;

    public Meter meter() {
        return this.meter;
    }

    public EchoMessageHandler(Meter meter, int messageSize) {
        this.meter = meter;
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active {}", (Object)NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        log.error("exception", e);
        ctx.close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        for (int i = 0; i < msgs.size(); ++i) {
            UdtMessage udtMsg = (UdtMessage)msgs.get(i);
            if (this.meter == null) continue;
            this.meter.mark((long)udtMsg.content().readableBytes());
        }
        ctx.write(msgs);
    }
}

