/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.nio;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.BufType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.udt.nio.NioUdtByteRendezvousChannel;
import io.netty.test.udt.nio.AbstractUdtTest;
import io.netty.test.udt.nio.NioUdtByteAcceptorChannelTest;
import io.netty.test.udt.nio.NioUdtMessageRendezvousChannelTest;
import io.netty.test.udt.util.BootHelp;
import io.netty.test.udt.util.EchoByteHandler;
import io.netty.test.udt.util.UnitHelp;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class NioUdtByteRendezvousChannelTest
extends AbstractUdtTest {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(NioUdtByteAcceptorChannelTest.class);

    @Test
    public void metadata() throws Exception {
        Assert.assertEquals((Object)BufType.BYTE, (Object)new NioUdtByteRendezvousChannel().metadata().bufferType());
    }

    @Test(timeout=10000L)
    public void basicEcho() throws Exception {
        int messageSize = 65536;
        int transferLimit = 0x100000;
        Meter rate1 = Metrics.newMeter(NioUdtMessageRendezvousChannelTest.class, (String)"send rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);
        Meter rate2 = Metrics.newMeter(NioUdtMessageRendezvousChannelTest.class, (String)"send rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);
        InetSocketAddress addr1 = UnitHelp.localSocketAddress();
        InetSocketAddress addr2 = UnitHelp.localSocketAddress();
        EchoByteHandler handler1 = new EchoByteHandler(rate1, 65536);
        EchoByteHandler handler2 = new EchoByteHandler(rate2, 65536);
        Bootstrap boot1 = BootHelp.bytePeerBoot(addr1, addr2, (ChannelHandler)handler1);
        Bootstrap boot2 = BootHelp.bytePeerBoot(addr2, addr1, (ChannelHandler)handler2);
        ChannelFuture connectFuture1 = boot1.connect();
        ChannelFuture connectFuture2 = boot2.connect();
        while (handler1.meter().count() < 0x100000L && handler2.meter().count() < 0x100000L) {
            log.info("progress : {} {}", (Object)handler1.meter().count(), (Object)handler2.meter().count());
            Thread.sleep(1000L);
        }
        connectFuture1.channel().close().sync();
        connectFuture2.channel().close().sync();
        log.info("handler1 : {}", (Object)handler1.meter().count());
        log.info("handler2 : {}", (Object)handler2.meter().count());
        Assert.assertTrue((handler1.meter().count() >= 0x100000L ? 1 : 0) != 0);
        Assert.assertTrue((handler2.meter().count() >= 0x100000L ? 1 : 0) != 0);
        Assert.assertEquals((long)handler1.meter().count(), (long)handler2.meter().count());
        boot1.shutdown();
        boot2.shutdown();
    }
}

