/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;

public class EchoByteHandler
extends ChannelInboundByteHandlerAdapter {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EchoByteHandler.class);
    private final ByteBuf message;
    private final Meter meter;

    public Meter meter() {
        return this.meter;
    }

    public EchoByteHandler(Meter meter, int messageSize) {
        this.meter = meter;
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active {}", (Object)NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
        ctx.flush();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) {
        if (this.meter != null) {
            this.meter.mark((long)in.readableBytes());
        }
        ByteBuf out = ctx.nextOutboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        log.error("exception : {}", (Object)e.getMessage());
        ctx.close();
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().directBuffer(((Integer)ctx.channel().config().getOption(ChannelOption.SO_RCVBUF)).intValue());
    }
}

