/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.Environment;
import com.google.caliper.EnvironmentGetter;
import com.google.caliper.Json;
import com.google.caliper.Result;
import com.google.caliper.Run;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import com.yammer.metrics.core.TimerContext;
import io.netty.test.udt.util.CaliperBench;
import io.netty.test.udt.util.CaliperMeasure;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CaliperRunner {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(CaliperRunner.class);

    private CaliperRunner() {
    }

    public static List<String> valueList(String valueText) {
        return Arrays.asList(valueText.split(","));
    }

    public static void execute(Class<? extends CaliperBench> klaz) throws Exception {
        CaliperRunner.execute("WARMUP", klaz);
        Run run = CaliperRunner.execute("REPORT", klaz);
        CaliperRunner.publish(CaliperRunner.newResult(run));
    }

    public static Run execute(String name, Class<? extends CaliperBench> klaz) throws Exception {
        CaliperBench booter = klaz.newInstance();
        List<Map<String, String>> varsSet = CaliperRunner.product(booter);
        Run run = CaliperRunner.newRun(klaz.getName());
        int index = 0;
        for (Map<String, String> vars : varsSet) {
            int done = 100 * index++ / varsSet.size();
            log.info("{} {}% {}", new Object[]{name, done, vars});
            ConfiguredBenchmark runner = booter.createBenchmark(vars);
            CaliperBench bench = (CaliperBench)runner.getBenchmark();
            CaliperMeasure measure = bench.measure();
            measure.variables().putAll(vars);
            runner.run(0);
            runner.close();
            measure.appendTo(run);
        }
        return run;
    }

    public static String json(Result result) {
        return Json.getGsonInstance().toJson((Object)result);
    }

    public static String signature(Map<String, String> map) {
        StringBuilder text = new StringBuilder();
        for (String item : map.values()) {
            text.append(String.format("%20s", item));
        }
        return text.toString();
    }

    public static List<Map<String, String>> product(SimpleBenchmark bench) {
        HashSet<Map<String, String>> collect = new HashSet<Map<String, String>>();
        TreeMap<String, Set<String>> pending = new TreeMap<String, Set<String>>();
        for (String name : new TreeSet(bench.parameterNames())) {
            pending.put(name, bench.parameterValues(name));
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(CaliperRunner.product(collect, pending));
        Comparator<Map<String, String>> comp = new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                return CaliperRunner.signature(o1).compareTo(CaliperRunner.signature(o2));
            }
        };
        Collections.sort(list, comp);
        return list;
    }

    public static Set<Map<String, String>> product(Set<Map<String, String>> collect, Map<String, Set<String>> pending) {
        if (pending.isEmpty()) {
            return collect;
        }
        HashSet extract = new HashSet();
        String key = pending.keySet().iterator().next();
        for (String value : pending.remove(key)) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put(key, value);
            extract.add(treeMap);
        }
        if (collect.isEmpty()) {
            collect.addAll(extract);
            return CaliperRunner.product(collect, pending);
        }
        HashSet<Map<String, String>> inject = new HashSet<Map<String, String>>();
        for (Map map : extract) {
            for (Map<String, String> mapColl : collect) {
                TreeMap<String, String> mapProd = new TreeMap<String, String>();
                mapProd.putAll(map);
                mapProd.putAll(mapColl);
                inject.add(mapProd);
            }
        }
        return CaliperRunner.product(inject, pending);
    }

    public static void publish(Result result) throws Exception {
        Runner runner = new Runner();
        Method method = runner.getClass().getDeclaredMethod("postResults", Result.class);
        method.setAccessible(true);
        method.invoke((Object)runner, result);
    }

    public static Run newRun(String benchmarkName) {
        HashMap measurements = new HashMap();
        Date executedTimestamp = new Date();
        Run run = new Run(measurements, benchmarkName, executedTimestamp);
        return run;
    }

    public static Result newResult(Run run) {
        Environment env = new EnvironmentGetter().getEnvironmentSnapshot();
        Result result = new Result(run, env);
        return result;
    }

    public static void main(String[] args) throws Exception {
        Run run = CaliperRunner.newRun("test-main");
        for (int param = 0; param < 5; ++param) {
            CaliperMeasure measure = new CaliperMeasure();
            measure.variables().put("param", String.valueOf(param));
            for (int step = 0; step < 5; ++step) {
                measure.rate().mark((long)(50 + step));
                TimerContext time = measure.time().time();
                Thread.sleep(15L);
                time.stop();
                measure.size().value(50 + step);
                measure.mark();
            }
            measure.appendTo(run);
        }
        Result result = CaliperRunner.newResult(run);
        CaliperRunner.publish(result);
        System.out.println(CaliperRunner.json(result));
    }
}

