/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.unix.UnixChannelUtil;
import java.util.Collections;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class UnixChannelUtilTest {
    private static final int IOV_MAX = 1024;

    @Test
    public void testPooledAllocatorIsBufferCopyNeededForWrite() {
        UnixChannelUtilTest.testIsBufferCopyNeededForWrite((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    @Test
    public void testUnPooledAllocatorIsBufferCopyNeededForWrite() {
        UnixChannelUtilTest.testIsBufferCopyNeededForWrite((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    private static void testIsBufferCopyNeededForWrite(ByteBufAllocator alloc) {
        ByteBuf byteBuf = alloc.directBuffer();
        Assert.assertFalse((boolean)UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf, 1024));
        Assert.assertFalse((boolean)UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf.asReadOnly(), 1024));
        Assert.assertTrue((boolean)byteBuf.release());
        byteBuf = alloc.heapBuffer();
        Assert.assertTrue((boolean)UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf, 1024));
        Assert.assertTrue((boolean)UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf.asReadOnly(), 1024));
        Assert.assertTrue((boolean)byteBuf.release());
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 2, 0, false);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 1025, 0, true);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 0, 2, true);
        UnixChannelUtilTest.assertCompositeByteBufIsBufferCopyNeededForWrite(alloc, 1, 1, true);
    }

    private static void assertCompositeByteBufIsBufferCopyNeededForWrite(ByteBufAllocator alloc, int numDirect, int numHeap, boolean expected) {
        CompositeByteBuf comp = alloc.compositeBuffer(numDirect + numHeap);
        LinkedList<ByteBuf> byteBufs = new LinkedList<ByteBuf>();
        while (numDirect > 0) {
            byteBufs.add(alloc.directBuffer(1));
            --numDirect;
        }
        while (numHeap > 0) {
            byteBufs.add(alloc.heapBuffer(1));
            --numHeap;
        }
        Collections.shuffle(byteBufs);
        for (ByteBuf byteBuf : byteBufs) {
            comp.addComponent(byteBuf);
        }
        Assert.assertEquals((String)((Object)byteBufs).toString(), (Object)expected, (Object)UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)comp, 1024));
        Assert.assertTrue((boolean)comp.release());
    }
}

