/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.channel.unix.Socket;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SocketTest<T extends Socket> {
    protected T socket;

    protected abstract T newSocket();

    @Before
    public void setup() {
        this.socket = this.newSocket();
    }

    @After
    public void tearDown() throws IOException {
        this.socket.close();
    }

    @Test
    public void testKeepAlive() throws Exception {
        Assert.assertFalse((boolean)this.socket.isKeepAlive());
        this.socket.setKeepAlive(true);
        Assert.assertTrue((boolean)this.socket.isKeepAlive());
    }

    @Test
    public void testTcpNoDelay() throws Exception {
        Assert.assertFalse((boolean)this.socket.isTcpNoDelay());
        this.socket.setTcpNoDelay(true);
        Assert.assertTrue((boolean)this.socket.isTcpNoDelay());
    }

    @Test
    public void testReceivedBufferSize() throws Exception {
        int size = this.socket.getReceiveBufferSize();
        int newSize = 65535;
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        this.socket.setReceiveBufferSize(newSize);
        Assert.assertTrue((newSize <= this.socket.getReceiveBufferSize() ? 1 : 0) != 0);
    }

    @Test
    public void testSendBufferSize() throws Exception {
        int size = this.socket.getSendBufferSize();
        int newSize = 65535;
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        this.socket.setSendBufferSize(newSize);
        Assert.assertTrue((newSize <= this.socket.getSendBufferSize() ? 1 : 0) != 0);
    }

    @Test
    public void testSoLinger() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.socket.getSoLinger());
        this.socket.setSoLinger(10);
        Assert.assertEquals((long)10L, (long)this.socket.getSoLinger());
    }

    @Test
    public void testDoubleCloseDoesNotThrow() throws IOException {
        Socket socket = Socket.newSocketStream();
        socket.close();
        socket.close();
    }
}

