/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class KQueueServerSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static KQueueServerSocketChannel ch;

    @BeforeClass
    public static void before() {
        group = new KQueueEventLoopGroup(1);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ch = (KQueueServerSocketChannel)((ServerBootstrap)bootstrap.group(group).channel(KQueueServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterClass
    public static void after() {
        try {
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testReusePort() {
        ch.config().setReusePort(false);
        Assert.assertFalse((boolean)ch.config().isReusePort());
        ch.config().setReusePort(true);
        Assert.assertTrue((boolean)ch.config().isReusePort());
    }

    @Test
    public void testAcceptFilter() {
        AcceptFilter currentFilter = ch.config().getAcceptFilter();
        Assume.assumeThat((Object)currentFilter, (Matcher)Matchers.not((Object)AcceptFilter.PLATFORM_UNSUPPORTED));
        AcceptFilter af = new AcceptFilter("test", "foo");
        ch.config().setAcceptFilter(af);
        Assert.assertEquals((Object)af, (Object)ch.config().getAcceptFilter());
    }

    @Test
    public void testOptionsDoesNotThrow() {
        Assert.assertFalse((boolean)ch.config().getOptions().isEmpty());
    }
}

