/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.LinuxSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class LinuxSocketTest {
    @BeforeClass
    public static void loadJNI() {
        Assume.assumeTrue((boolean)Epoll.isAvailable());
    }

    @Test(expected=IOException.class)
    public void testBindNonIpv6SocketToInet6AddressThrows() throws Exception {
        LinuxSocket socket = LinuxSocket.newSocketStream(false);
        try {
            socket.bind(new InetSocketAddress(InetAddress.getByAddress(new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49}), 0));
        }
        finally {
            socket.close();
        }
    }

    @Test(expected=IOException.class)
    public void testConnectNonIpv6SocketToInet6AddressThrows() throws Exception {
        LinuxSocket socket = LinuxSocket.newSocketStream(false);
        try {
            socket.connect(new InetSocketAddress(InetAddress.getByAddress(new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49}), 1234));
        }
        finally {
            socket.close();
        }
    }
}

