/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class EpollTest {
    @Test
    public void testIsAvailable() {
        Assert.assertTrue((boolean)Epoll.isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testEpollWaitWithTimeOutMinusOne() throws Exception {
        final EpollEventArray eventArray = new EpollEventArray(8);
        try {
            final FileDescriptor epoll = Native.newEpollCreate();
            FileDescriptor timerFd = Native.newTimerFd();
            final FileDescriptor eventfd = Native.newEventFd();
            Native.epollCtlAdd(epoll.intValue(), timerFd.intValue(), Native.EPOLLIN);
            Native.epollCtlAdd(epoll.intValue(), eventfd.intValue(), Native.EPOLLIN);
            final AtomicReference ref = new AtomicReference();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Assert.assertEquals((long)1L, (long)Native.epollWait(epoll, eventArray, false));
                        Assert.assertEquals((long)eventfd.intValue(), (long)eventArray.fd(0));
                    }
                    catch (Throwable cause) {
                        ref.set(cause);
                    }
                }
            });
            t.start();
            t.join(1000L);
            Assert.assertTrue((boolean)t.isAlive());
            Native.eventFdWrite(eventfd.intValue(), 1L);
            t.join();
            Assert.assertNull(ref.get());
            epoll.close();
            timerFd.close();
            eventfd.close();
        }
        finally {
            eventArray.free();
        }
    }
}

