/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketTestPermutation;
import io.netty.channel.epoll.Native;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class EpollReuseAddrTest {
    private static final int MAJOR;
    private static final int MINOR;
    private static final int BUGFIX;

    @Test
    public void testMultipleBindSocketChannelWithoutReusePortFails() {
        Assume.assumeTrue((boolean)EpollReuseAddrTest.versionEqOrGt(3, 9, 0));
        EpollReuseAddrTest.testMultipleBindDatagramChannelWithoutReusePortFails0(EpollReuseAddrTest.createServerBootstrap());
    }

    @Test
    public void testMultipleBindDatagramChannelWithoutReusePortFails() {
        Assume.assumeTrue((boolean)EpollReuseAddrTest.versionEqOrGt(3, 9, 0));
        EpollReuseAddrTest.testMultipleBindDatagramChannelWithoutReusePortFails0(EpollReuseAddrTest.createBootstrap());
    }

    private static void testMultipleBindDatagramChannelWithoutReusePortFails0(AbstractBootstrap<?, ?> bootstrap) {
        bootstrap.handler((ChannelHandler)new LoggingHandler(LogLevel.ERROR));
        ChannelFuture future = bootstrap.bind().syncUninterruptibly();
        try {
            bootstrap.bind(future.channel().localAddress()).syncUninterruptibly();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
        future.channel().close().syncUninterruptibly();
    }

    @Test(timeout=10000L)
    public void testMultipleBindSocketChannel() throws Exception {
        Assume.assumeTrue((boolean)EpollReuseAddrTest.versionEqOrGt(3, 9, 0));
        ServerBootstrap bootstrap = EpollReuseAddrTest.createServerBootstrap();
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        AtomicBoolean accepted1 = new AtomicBoolean();
        bootstrap.childHandler((ChannelHandler)new ServerSocketTestHandler(accepted1));
        ChannelFuture future = bootstrap.bind().syncUninterruptibly();
        InetSocketAddress address1 = (InetSocketAddress)future.channel().localAddress();
        AtomicBoolean accepted2 = new AtomicBoolean();
        bootstrap.childHandler((ChannelHandler)new ServerSocketTestHandler(accepted2));
        ChannelFuture future2 = bootstrap.bind((SocketAddress)address1).syncUninterruptibly();
        InetSocketAddress address2 = (InetSocketAddress)future2.channel().localAddress();
        Assert.assertEquals((Object)address1, (Object)address2);
        while (!accepted1.get() || !accepted2.get()) {
            Socket socket = new Socket(address1.getAddress(), address1.getPort());
            socket.setReuseAddress(true);
            socket.close();
        }
        future.channel().close().syncUninterruptibly();
        future2.channel().close().syncUninterruptibly();
    }

    @Test(timeout=10000L)
    @Ignore
    public void testMultipleBindDatagramChannel() throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
        Assume.assumeTrue((boolean)EpollReuseAddrTest.versionEqOrGt(3, 9, 0));
        Bootstrap bootstrap = EpollReuseAddrTest.createBootstrap();
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        final AtomicBoolean received1 = new AtomicBoolean();
        bootstrap.handler((ChannelHandler)new DatagramSocketTestHandler(received1));
        ChannelFuture future = bootstrap.bind().syncUninterruptibly();
        final InetSocketAddress address1 = (InetSocketAddress)future.channel().localAddress();
        final AtomicBoolean received2 = new AtomicBoolean();
        bootstrap.handler((ChannelHandler)new DatagramSocketTestHandler(received2));
        ChannelFuture future2 = bootstrap.bind((SocketAddress)address1).syncUninterruptibly();
        InetSocketAddress address2 = (InetSocketAddress)future2.channel().localAddress();
        Assert.assertEquals((Object)address1, (Object)address2);
        final byte[] bytes = "data".getBytes();
        int count = 16;
        final CountDownLatch latch = new CountDownLatch(count);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DatagramSocket socket = new DatagramSocket();
                    while (!received1.get() || !received2.get()) {
                        socket.send(new DatagramPacket(bytes, 0, bytes.length, address1.getAddress(), address1.getPort()));
                    }
                    socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                latch.countDown();
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(count);
        for (int i = 0; i < count; ++i) {
            executor.execute(r);
        }
        latch.await();
        executor.shutdown();
        future.channel().close().syncUninterruptibly();
        future2.channel().close().syncUninterruptibly();
        Assert.assertTrue((boolean)received1.get());
        Assert.assertTrue((boolean)received2.get());
    }

    private static ServerBootstrap createServerBootstrap() {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(EpollSocketTestPermutation.EPOLL_BOSS_GROUP, EpollSocketTestPermutation.EPOLL_WORKER_GROUP);
        bootstrap.channel(EpollServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new DummyHandler());
        InetSocketAddress address = new InetSocketAddress(NetUtil.LOCALHOST, 0);
        bootstrap.localAddress((SocketAddress)address);
        return bootstrap;
    }

    private static Bootstrap createBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(EpollSocketTestPermutation.EPOLL_WORKER_GROUP);
        bootstrap.channel(EpollDatagramChannel.class);
        InetSocketAddress address = new InetSocketAddress(NetUtil.LOCALHOST, 0);
        bootstrap.localAddress((SocketAddress)address);
        return bootstrap;
    }

    private static boolean versionEqOrGt(int major, int minor, int bugfix) {
        if (MAJOR > major) {
            return true;
        }
        if (MAJOR == major) {
            if (MINOR > minor) {
                return true;
            }
            if (MINOR == minor && BUGFIX >= bugfix) {
                return true;
            }
        }
        return false;
    }

    static {
        String[] versionParts;
        String kernelVersion = Native.KERNEL_VERSION;
        int index = kernelVersion.indexOf(45);
        if (index > -1) {
            kernelVersion = kernelVersion.substring(0, index);
        }
        if ((versionParts = kernelVersion.split("\\.")).length <= 3) {
            MAJOR = Integer.parseInt(versionParts[0]);
            MINOR = Integer.parseInt(versionParts[1]);
            BUGFIX = versionParts.length == 3 ? Integer.parseInt(versionParts[2]) : 0;
        } else {
            throw new IllegalStateException("Can not parse kernel version " + kernelVersion);
        }
    }

    @ChannelHandler.Sharable
    private static final class DummyHandler
    extends ChannelHandlerAdapter {
        private DummyHandler() {
        }
    }

    @ChannelHandler.Sharable
    private static class DatagramSocketTestHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicBoolean received;

        DatagramSocketTestHandler(AtomicBoolean received) {
            this.received = received;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ReferenceCountUtil.release((Object)msg);
            this.received.set(true);
        }
    }

    @ChannelHandler.Sharable
    private static class ServerSocketTestHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicBoolean accepted;

        ServerSocketTestHandler(AtomicBoolean accepted) {
            this.accepted = accepted;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.accepted.set(true);
            ctx.close();
        }
    }
}

