/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.tests.UnixTestUtils;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;

class EpollSocketTestPermutation
extends SocketTestPermutation {
    static final EpollSocketTestPermutation INSTANCE = new EpollSocketTestPermutation();
    static final EventLoopGroup EPOLL_BOSS_GROUP = new EpollEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-epoll-boss", true));
    static final EventLoopGroup EPOLL_WORKER_GROUP = new EpollEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-epoll-worker", true));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollSocketTestPermutation.class);

    EpollSocketTestPermutation() {
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List list = this.combo(this.serverSocket(), this.clientSocket());
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(EPOLL_BOSS_GROUP, EPOLL_WORKER_GROUP).channel(EpollServerSocketChannel.class);
            }
        });
        if (this.isServerFastOpen()) {
            toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

                public ServerBootstrap newInstance() {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)new ServerBootstrap().group(EPOLL_BOSS_GROUP, EPOLL_WORKER_GROUP).channel(EpollServerSocketChannel.class);
                    serverBootstrap.option(EpollChannelOption.TCP_FASTOPEN, (Object)5);
                    return serverBootstrap;
                }
            });
        }
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(EpollSocketTestPermutation.this.nioBossGroup, EpollSocketTestPermutation.this.nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_WORKER_GROUP)).channel(EpollSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EpollSocketTestPermutation.this.nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final InternetProtocolFamily family) {
        List<TestsuitePermutation.BootstrapFactory> bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EpollSocketTestPermutation.this.nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_WORKER_GROUP)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new EpollDatagramChannel(family);
                    }

                    public String toString() {
                        return InternetProtocolFamily.class.getSimpleName() + ".class";
                    }
                });
            }
        });
        return this.combo(bfs, bfs);
    }

    List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> epollOnlyDatagram(InternetProtocolFamily family) {
        return this.combo(Collections.singletonList(this.datagramBootstrapFactory(family)), Collections.singletonList(this.datagramBootstrapFactory(family)));
    }

    private TestsuitePermutation.BootstrapFactory<Bootstrap> datagramBootstrapFactory(final InternetProtocolFamily family) {
        return new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_WORKER_GROUP)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new EpollDatagramChannel(family);
                    }

                    public String toString() {
                        return InternetProtocolFamily.class.getSimpleName() + ".class";
                    }
                });
            }
        };
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> domainSocket() {
        List list = this.combo(this.serverDomainSocket(), this.clientDomainSocket());
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(EPOLL_BOSS_GROUP, EPOLL_WORKER_GROUP).channel(EpollServerDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_WORKER_GROUP)).channel(EpollDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_WORKER_GROUP)).channel(EpollDatagramChannel.class);
            }
        });
    }

    public boolean isServerFastOpen() {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Integer run() {
                int fastopen = 0;
                File file = new File("/proc/sys/net/ipv4/tcp_fastopen");
                if (file.exists()) {
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new FileReader(file));
                        fastopen = Integer.parseInt(in.readLine());
                        if (!logger.isDebugEnabled()) return fastopen;
                        logger.debug("{}: {}", (Object)file, (Object)fastopen);
                        return fastopen;
                    }
                    catch (Exception e) {
                        logger.debug("Failed to get TCP_FASTOPEN from: {}", (Object)file, (Object)e);
                        return fastopen;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!logger.isDebugEnabled()) return fastopen;
                logger.debug("{}: {} (non-existent)", (Object)file, (Object)fastopen);
                return fastopen;
            }
        }) == 3;
    }

    public static DomainSocketAddress newSocketAddress() {
        return UnixTestUtils.newSocketAddress();
    }
}

