/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.Hidden;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import reactor.blockhound.BlockHound;
import reactor.blockhound.BlockingOperationError;
import reactor.blockhound.integration.BlockHoundIntegration;

public class NettyBlockHoundIntegrationTest {
    @BeforeClass
    public static void setUpClass() {
        BlockHound.install((BlockHoundIntegration[])new BlockHoundIntegration[0]);
    }

    @Test
    public void testServiceLoader() {
        for (BlockHoundIntegration integration : ServiceLoader.load(BlockHoundIntegration.class)) {
            if (!(integration instanceof Hidden.NettyBlockHoundIntegration)) continue;
            return;
        }
        Assert.fail((String)"NettyBlockHoundIntegration cannot be loaded with ServiceLoader");
    }

    @Test
    public void testBlockingCallsInNettyThreads() throws Exception {
        FutureTask<Void> future = new FutureTask<Void>(() -> {
            Thread.sleep(0L);
            return null;
        });
        GlobalEventExecutor.INSTANCE.execute(future);
        try {
            future.get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected an exception due to a blocking call but none was thrown");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(BlockingOperationError.class));
        }
    }

    @Test(timeout=5000L)
    public void testGlobalEventExecutorTakeTask() throws InterruptedException {
        NettyBlockHoundIntegrationTest.testEventExecutorTakeTask((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    @Test(timeout=5000L)
    public void testSingleThreadEventExecutorTakeTask() throws InterruptedException {
        SingleThreadEventExecutor executor = new SingleThreadEventExecutor(null, (ThreadFactory)new DefaultThreadFactory("test"), true){

            protected void run() {
                while (!this.confirmShutdown()) {
                    Runnable task = this.takeTask();
                    if (task == null) continue;
                    task.run();
                }
            }
        };
        NettyBlockHoundIntegrationTest.testEventExecutorTakeTask((EventExecutor)executor);
    }

    private static void testEventExecutorTakeTask(EventExecutor eventExecutor) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture f = eventExecutor.schedule(latch::countDown, 10L, TimeUnit.MILLISECONDS);
        f.sync();
        latch.await();
    }

    @Test
    public void testHandshakeWithExecutorThatExecuteDirectory() throws Exception {
        NettyBlockHoundIntegrationTest.testHandshakeWithExecutor(Runnable::run);
    }

    @Test
    public void testHandshakeWithImmediateExecutor() throws Exception {
        NettyBlockHoundIntegrationTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE);
    }

    @Test
    public void testHandshakeWithImmediateEventExecutor() throws Exception {
        NettyBlockHoundIntegrationTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE);
    }

    @Test
    public void testHandshakeWithExecutor() throws Exception {
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            NettyBlockHoundIntegrationTest.testHandshakeWithExecutor(executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeWithExecutor(Executor executor) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, executor);
        SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, executor);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)serverSslHandler).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslHandshakeCompletionEvent && ((SslHandshakeCompletionEvent)evt).cause() != null) {
                                ((SslHandshakeCompletionEvent)evt).cause().printStackTrace();
                            }
                            ctx.fireUserEventTriggered(evt);
                        }
                    }});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            Assert.assertTrue((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            Assert.assertTrue((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }
}

