/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.Hidden;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class NettyBlockHoundIntegrationTest {
    @BeforeClass
    public static void setUpClass() {
        BlockHound.install((BlockHoundIntegration[])new BlockHoundIntegration[0]);
    }

    @Test
    public void testServiceLoader() {
        for (BlockHoundIntegration integration : ServiceLoader.load(BlockHoundIntegration.class)) {
            if (!(integration instanceof Hidden.NettyBlockHoundIntegration)) continue;
            return;
        }
        Assert.fail((String)"NettyBlockHoundIntegration cannot be loaded with ServiceLoader");
    }

    @Test
    public void testBlockingCallsInNettyThreads() throws Exception {
        FutureTask<Void> future = new FutureTask<Void>(() -> {
            Thread.sleep(0L);
            return null;
        });
        GlobalEventExecutor.INSTANCE.execute(future);
        try {
            future.get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected an exception due to a blocking call but none was thrown");
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            Assert.assertNotNull((String)"An exception was thrown", (Object)throwable);
            Assert.assertTrue((String)"Blocking call was reported", (boolean)throwable.getMessage().contains("Blocking call"));
        }
    }
}

