/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.SocketChannel;
import io.netty.testsuite.transport.socket.AbstractServerSocketTest;
import io.netty.util.internal.SocketUtils;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class SocketShutdownOutputByPeerTest
extends AbstractServerSocketTest {
    @Test(timeout=30000L)
    public void testShutdownOutput() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutput(ServerBootstrap sb) throws Throwable {
        TestHandler h = new TestHandler();
        Socket s = new Socket();
        try {
            sb.childHandler((ChannelHandler)h).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true).bind().sync();
            SocketUtils.connect((Socket)s, (SocketAddress)this.addr, (int)10000);
            s.getOutputStream().write(1);
            Assert.assertEquals((long)1L, (long)h.queue.take().byteValue());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            s.shutdownOutput();
            h.halfClosure.await();
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertTrue((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            Assert.assertEquals((long)1L, (long)h.closure.getCount());
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)h.halfClosureCount.intValue());
        }
        finally {
            s.close();
        }
    }

    @Test(timeout=30000L)
    public void testShutdownOutputWithoutOption() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutputWithoutOption(ServerBootstrap sb) throws Throwable {
        TestHandler h = new TestHandler();
        Socket s = new Socket();
        try {
            sb.childHandler((ChannelHandler)h).bind().sync();
            SocketUtils.connect((Socket)s, (SocketAddress)this.addr, (int)10000);
            s.getOutputStream().write(1);
            Assert.assertEquals((long)1L, (long)h.queue.take().byteValue());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            s.shutdownOutput();
            h.closure.await();
            Assert.assertFalse((boolean)h.ch.isOpen());
            Assert.assertFalse((boolean)h.ch.isActive());
            Assert.assertTrue((boolean)h.ch.isInputShutdown());
            Assert.assertTrue((boolean)h.ch.isOutputShutdown());
            Assert.assertEquals((long)1L, (long)h.halfClosure.getCount());
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)h.halfClosureCount.intValue());
        }
        finally {
            s.close();
        }
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile SocketChannel ch;
        final BlockingQueue<Byte> queue = new LinkedBlockingQueue<Byte>();
        final CountDownLatch halfClosure = new CountDownLatch(1);
        final CountDownLatch closure = new CountDownLatch(1);
        final AtomicInteger halfClosureCount = new AtomicInteger();

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.ch = (SocketChannel)ctx.channel();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.closure.countDown();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.queue.offer(msg.readByte());
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ChannelInputShutdownEvent) {
                this.halfClosureCount.incrementAndGet();
                this.halfClosure.countDown();
            }
        }
    }
}

