/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketAddress;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SocketConnectionAttemptTest
extends AbstractClientSocketTest {
    private static final int UNASSIGNED_PORT = 4;

    @Test(timeout=30000L)
    public void testConnectTimeout() throws Throwable {
        this.run();
    }

    public void testConnectTimeout(Bootstrap cb) throws Throwable {
        ((Bootstrap)cb.handler((ChannelHandler)new TestHandler())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000);
        ChannelFuture future = cb.connect(SocketTestPermutation.BAD_HOST, SocketTestPermutation.BAD_PORT);
        try {
            MatcherAssert.assertThat((Object)future.await(3000L), (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            future.channel().close();
        }
    }

    @Test(timeout=30000L)
    public void testConnectRefused() throws Throwable {
        this.run();
    }

    public void testConnectRefused(Bootstrap cb) throws Throwable {
        SocketConnectionAttemptTest.testConnectRefused0(cb, false);
    }

    @Test(timeout=30000L)
    public void testConnectRefusedHalfClosure() throws Throwable {
        this.run();
    }

    public void testConnectRefusedHalfClosure(Bootstrap cb) throws Throwable {
        SocketConnectionAttemptTest.testConnectRefused0(cb, true);
    }

    private static void testConnectRefused0(Bootstrap cb, boolean halfClosure) throws Throwable {
        final Promise errorPromise = GlobalEventExecutor.INSTANCE.newPromise();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                errorPromise.setFailure((Throwable)((Object)new AssertionError((Object)"should have never been called")));
            }
        };
        cb.handler((ChannelHandler)handler);
        cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)halfClosure);
        ChannelFuture future = cb.connect(NetUtil.LOCALHOST, 4).awaitUninterruptibly();
        MatcherAssert.assertThat((Object)future.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectException.class)));
        MatcherAssert.assertThat((Object)errorPromise.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectCancellation() throws Throwable {
        boolean badHostTimedOut = true;
        Socket socket = new Socket();
        try {
            SocketUtils.connect((Socket)socket, (SocketAddress)SocketUtils.socketAddress((String)SocketTestPermutation.BAD_HOST, (int)SocketTestPermutation.BAD_PORT), (int)10);
        }
        catch (ConnectException e) {
            badHostTimedOut = false;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        Assume.assumeThat((String)("The connection attempt to " + SocketTestPermutation.BAD_HOST + " does not time out."), (Object)badHostTimedOut, (Matcher)CoreMatchers.is((Object)true));
        this.run();
    }

    public void testConnectCancellation(Bootstrap cb) throws Throwable {
        ((Bootstrap)cb.handler((ChannelHandler)new TestHandler())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4000);
        ChannelFuture future = cb.connect(SocketTestPermutation.BAD_HOST, SocketTestPermutation.BAD_PORT);
        try {
            if (future.await(1000L)) {
                if (future.isSuccess()) {
                    Assert.fail((String)("A connection attempt to " + SocketTestPermutation.BAD_HOST + " must not succeed."));
                } else {
                    throw future.cause();
                }
            }
            if (future.cancel(true)) {
                MatcherAssert.assertThat((Object)future.channel().closeFuture().await(500L), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)future.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
            }
        }
        finally {
            future.channel().close();
        }
    }

    private static class TestHandler
    extends ChannelInboundHandlerAdapter {
        private TestHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            InternalLoggerFactory.getInstance(SocketConnectionAttemptTest.class).warn("Unexpected exception:", cause);
        }
    }
}

