/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SocketShutdownOutputBySelfTest
extends AbstractClientSocketTest {
    @Test(timeout=30000L)
    public void testShutdownOutput() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutput(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        SocketChannel ch = null;
        try {
            ss.bind(this.newSocketAddress());
            ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assert.assertTrue((boolean)ch.isActive());
            Assert.assertFalse((boolean)ch.isOutputShutdown());
            s = ss.accept();
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1})).sync();
            Assert.assertEquals((long)1L, (long)s.getInputStream().read());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            ch.shutdownOutput().sync();
            Assert.assertEquals((long)-1L, (long)s.getInputStream().read());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertTrue((boolean)h.ch.isOutputShutdown());
            s.getOutputStream().write(new byte[]{1});
            Assert.assertEquals((long)1L, (long)h.queue.take().byteValue());
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (ch != null) {
                ch.close();
            }
            ss.close();
        }
    }

    @Test(timeout=30000L)
    public void testShutdownOutputAfterClosed() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutputAfterClosed(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        try {
            ss.bind(this.newSocketAddress());
            SocketChannel ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assert.assertTrue((boolean)ch.isActive());
            s = ss.accept();
            ch.close().syncUninterruptibly();
            try {
                ch.shutdownInput().syncUninterruptibly();
                Assert.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
            try {
                ch.shutdownOutput().syncUninterruptibly();
                Assert.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            ss.close();
        }
    }

    @Test(timeout=30000L)
    public void testWriteAfterShutdownOutputNoWritabilityChange() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteAfterShutdownOutputNoWritabilityChange(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        SocketChannel ch = null;
        try {
            ss.bind(this.newSocketAddress());
            cb.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2, 4));
            ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assume.assumeFalse((boolean)(ch instanceof OioSocketChannel));
            Assert.assertTrue((boolean)ch.isActive());
            Assert.assertFalse((boolean)ch.isOutputShutdown());
            s = ss.accept();
            byte[] expectedBytes = new byte[]{1, 2, 3, 4, 5, 6};
            ChannelFuture writeFuture = ch.write((Object)Unpooled.wrappedBuffer((byte[])expectedBytes));
            h.assertWritability(false);
            ch.flush();
            writeFuture.sync();
            h.assertWritability(true);
            for (int i = 0; i < expectedBytes.length; ++i) {
                Assert.assertEquals((long)expectedBytes[i], (long)s.getInputStream().read());
            }
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            ch.shutdownOutput().sync();
            Assert.assertEquals((long)-1L, (long)s.getInputStream().read());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertTrue((boolean)h.ch.isOutputShutdown());
            try {
                ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{2})).sync();
                Assert.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
            Assert.assertNull((Object)h.writabilityQueue.poll());
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (ch != null) {
                ch.close();
            }
            ss.close();
        }
    }

    @Test(timeout=30000L)
    public void testShutdownOutputSoLingerNoAssertError() throws Throwable {
        this.run();
    }

    public void testShutdownOutputSoLingerNoAssertError(Bootstrap cb) throws Throwable {
        this.testShutdownSoLingerNoAssertError0(cb, true);
    }

    @Test(timeout=30000L)
    public void testShutdownSoLingerNoAssertError() throws Throwable {
        this.run();
    }

    public void testShutdownSoLingerNoAssertError(Bootstrap cb) throws Throwable {
        this.testShutdownSoLingerNoAssertError0(cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testShutdownSoLingerNoAssertError0(Bootstrap cb, boolean output) throws Throwable {
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        ChannelFuture cf = null;
        try {
            ss.bind(this.newSocketAddress());
            cf = ((Bootstrap)((Bootstrap)cb.option(ChannelOption.SO_LINGER, (Object)1)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).connect(ss.getLocalSocketAddress()).sync();
            s = ss.accept();
            cf.sync();
            if (output) {
                ((SocketChannel)cf.channel()).shutdownOutput().sync();
            } else {
                ((SocketChannel)cf.channel()).shutdown().sync();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (cf != null) {
                cf.channel().close();
            }
            ss.close();
        }
    }

    private static void checkThrowable(Throwable cause) throws Throwable {
        if (!(cause instanceof ClosedChannelException) && !(cause instanceof SocketException)) {
            throw cause;
        }
    }

    private static final class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile SocketChannel ch;
        final BlockingQueue<Byte> queue = new LinkedBlockingQueue<Byte>();
        final BlockingDeque<Boolean> writabilityQueue = new LinkedBlockingDeque<Boolean>();

        private TestHandler() {
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            this.writabilityQueue.add(ctx.channel().isWritable());
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.ch = (SocketChannel)ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.queue.offer(msg.readByte());
        }

        private void drainWritabilityQueue() throws InterruptedException {
            while (this.writabilityQueue.poll(100L, TimeUnit.MILLISECONDS) != null) {
            }
        }

        void assertWritability(boolean isWritable) throws InterruptedException {
            try {
                Boolean writability = this.writabilityQueue.takeLast();
                Assert.assertEquals((Object)isWritable, (Object)writability);
                this.drainWritabilityQueue();
            }
            catch (Throwable c) {
                c.printStackTrace();
            }
        }
    }
}

