/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.PortUnreachableException;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DatagramConnectNotExistsTest
extends AbstractClientSocketTest {
    @Override
    protected List<TestsuitePermutation.BootstrapFactory<Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagramSocket();
    }

    @Test(timeout=10000L)
    public void testConnectNotExists() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectNotExists(Bootstrap cb) throws Throwable {
        final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                promise.trySuccess((Object)cause);
            }
        });
        ChannelFuture future = cb.connect(NetUtil.LOCALHOST, SocketTestPermutation.BAD_PORT);
        try {
            Channel datagramChannel = future.syncUninterruptibly().channel();
            Assert.assertTrue((boolean)datagramChannel.isActive());
            datagramChannel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII)).syncUninterruptibly();
            if (!(datagramChannel instanceof OioDatagramChannel)) {
                Assert.assertTrue((boolean)(promise.syncUninterruptibly().getNow() instanceof PortUnreachableException));
            }
        }
        finally {
            future.channel().close();
        }
    }
}

