/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public abstract class AbstractSocketReuseFdTest
extends AbstractSocketTest {
    @Override
    protected abstract SocketAddress newSocketAddress();

    @Override
    protected abstract List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> newFactories();

    @Test(timeout=60000L)
    public void testReuseFd() throws Throwable {
        this.run();
    }

    public void testReuseFd(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        sb.childOption(ChannelOption.AUTO_READ, (Object)true);
        cb.option(ChannelOption.AUTO_READ, (Object)true);
        int numChannels = 100;
        final AtomicReference globalException = new AtomicReference();
        final AtomicInteger serverRemaining = new AtomicInteger(numChannels);
        final AtomicInteger clientRemaining = new AtomicInteger(numChannels);
        final Promise serverDonePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        final Promise clientDonePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) {
                ReuseFdHandler sh = new ReuseFdHandler(false, globalException, serverRemaining, (Promise<Void>)serverDonePromise);
                sch.pipeline().addLast("handler", (ChannelHandler)sh);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) {
                ReuseFdHandler ch = new ReuseFdHandler(true, globalException, clientRemaining, (Promise<Void>)clientDonePromise);
                sch.pipeline().addLast("handler", (ChannelHandler)ch);
            }
        });
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    clientDonePromise.tryFailure(future.cause());
                }
            }
        };
        Channel sc = sb.bind().sync().channel();
        for (int i = 0; i < numChannels; ++i) {
            cb.connect(sc.localAddress()).addListener((GenericFutureListener)listener);
        }
        clientDonePromise.sync();
        serverDonePromise.sync();
        sc.close().sync();
        if (globalException.get() != null && !(globalException.get() instanceof IOException)) {
            throw (Throwable)globalException.get();
        }
    }

    static class ReuseFdHandler
    extends ChannelInboundHandlerAdapter {
        private static final String EXPECTED_PAYLOAD = "payload";
        private final Promise<Void> donePromise;
        private final AtomicInteger remaining;
        private final boolean client;
        volatile Channel channel;
        final AtomicReference<Throwable> globalException;
        final AtomicReference<Throwable> exception = new AtomicReference();
        final StringBuilder received = new StringBuilder();

        ReuseFdHandler(boolean client, AtomicReference<Throwable> globalException, AtomicInteger remaining, Promise<Void> donePromise) {
            this.client = client;
            this.globalException = globalException;
            this.remaining = remaining;
            this.donePromise = donePromise;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.channel = ctx.channel();
            if (this.client) {
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)EXPECTED_PAYLOAD, (Charset)CharsetUtil.US_ASCII));
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                this.received.append(buf.toString(CharsetUtil.US_ASCII));
                buf.release();
                if (this.received.toString().equals(EXPECTED_PAYLOAD)) {
                    if (this.client) {
                        ctx.close();
                    } else {
                        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)EXPECTED_PAYLOAD, (Charset)CharsetUtil.US_ASCII));
                    }
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (this.exception.compareAndSet(null, cause)) {
                this.donePromise.tryFailure((Throwable)new IllegalStateException("exceptionCaught: " + ctx.channel(), cause));
                ctx.close();
            }
            this.globalException.compareAndSet(null, cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.remaining.decrementAndGet() == 0) {
                if (this.received.toString().equals(EXPECTED_PAYLOAD)) {
                    this.donePromise.setSuccess(null);
                } else {
                    this.donePromise.tryFailure((Throwable)new Exception("Unexpected payload:" + this.received));
                }
            }
        }
    }
}

