/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.socket.ServerSocketChannel;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSingleThreadEventLoopTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelsRegistered() {
        EventLoopGroup group = this.newEventLoopGroup();
        SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            ServerSocketChannel ch1 = this.newChannel();
            ServerSocketChannel ch2 = this.newChannel();
            Assert.assertEquals((long)0L, (long)loop.registeredChannels());
            Assert.assertTrue((boolean)loop.register((Channel)ch1).syncUninterruptibly().isSuccess());
            Assert.assertTrue((boolean)loop.register((Channel)ch2).syncUninterruptibly().isSuccess());
            Assert.assertEquals((long)2L, (long)loop.registeredChannels());
            Assert.assertTrue((boolean)ch1.deregister().syncUninterruptibly().isSuccess());
            Assert.assertEquals((long)1L, (long)loop.registeredChannels());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract ServerSocketChannel newChannel();
}

