/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public abstract class AbstractDatagramTest
extends AbstractComboTestsuiteTest<Bootstrap, Bootstrap> {
    protected AbstractDatagramTest() {
        super(Bootstrap.class, Bootstrap.class);
    }

    @Override
    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagram(InternetProtocolFamily.IPv4);
    }

    @Override
    protected void configure(Bootstrap bootstrap, Bootstrap bootstrap2, ByteBufAllocator allocator) {
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
        bootstrap2.option(ChannelOption.ALLOCATOR, (Object)allocator);
    }

    protected SocketAddress newSocketAddress() {
        switch (this.internetProtocolFamily()) {
            case IPv4: {
                return new InetSocketAddress(NetUtil.LOCALHOST4, 0);
            }
            case IPv6: {
                return new InetSocketAddress(NetUtil.LOCALHOST6, 0);
            }
        }
        throw new AssertionError();
    }

    protected InternetProtocolFamily internetProtocolFamily() {
        return InternetProtocolFamily.IPv4;
    }
}

