/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.channel.socket.DuplexChannel;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketHalfClosedTest
extends AbstractSocketTest {
    @Test(timeout=10000L)
    public void testHalfClosureOnlyOneEventWhenAutoRead() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHalfClosureOnlyOneEventWhenAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        try {
            ((Bootstrap)cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)true);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ((DuplexChannel)ctx).shutdownOutput();
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            final AtomicInteger shutdownEventReceivedCounter = new AtomicInteger();
            final AtomicInteger shutdownReadCompleteEventReceivedCounter = new AtomicInteger();
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) {
                            if (evt == ChannelInputShutdownEvent.INSTANCE) {
                                shutdownEventReceivedCounter.incrementAndGet();
                            } else if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                                shutdownReadCompleteEventReceivedCounter.incrementAndGet();
                                ctx.executor().schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        ctx.close();
                                    }
                                }, 100L, TimeUnit.MILLISECONDS);
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().sync().channel();
            Channel clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            clientChannel.closeFuture().await();
            Assert.assertEquals((long)1L, (long)shutdownEventReceivedCounter.get());
            Assert.assertEquals((long)1L, (long)shutdownReadCompleteEventReceivedCounter.get());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
        }
    }

    @Test
    public void testAllDataReadAfterHalfClosure() throws Throwable {
        this.run();
    }

    public void testAllDataReadAfterHalfClosure(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketHalfClosedTest.testAllDataReadAfterHalfClosure(true, sb, cb);
        SocketHalfClosedTest.testAllDataReadAfterHalfClosure(false, sb, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAllDataReadAfterHalfClosure(final boolean autoRead, ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int totalServerBytesWritten = 16384;
        int numReadsPerReadLoop = 2;
        final CountDownLatch serverInitializedLatch = new CountDownLatch(1);
        final CountDownLatch clientReadAllDataLatch = new CountDownLatch(1);
        final CountDownLatch clientHalfClosedLatch = new CountDownLatch(1);
        final AtomicInteger clientReadCompletes = new AtomicInteger();
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            ((Bootstrap)((Bootstrap)cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestNumReadsRecvByteBufAllocator(2));
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            ByteBuf buf = ctx.alloc().buffer(16384);
                            buf.writerIndex(buf.capacity());
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    ((DuplexChannel)future.channel()).shutdownOutput();
                                }
                            });
                            serverInitializedLatch.countDown();
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int bytesRead;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            ByteBuf buf = (ByteBuf)msg;
                            this.bytesRead += buf.readableBytes();
                            buf.release();
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt == ChannelInputShutdownEvent.INSTANCE) {
                                clientHalfClosedLatch.countDown();
                            } else if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                                ctx.close();
                            }
                        }

                        public void channelReadComplete(ChannelHandlerContext ctx) {
                            clientReadCompletes.incrementAndGet();
                            if (this.bytesRead == 16384) {
                                clientReadAllDataLatch.countDown();
                            }
                            if (!autoRead) {
                                ctx.read();
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            clientChannel.read();
            serverInitializedLatch.await();
            clientReadAllDataLatch.await();
            clientHalfClosedLatch.await();
            Assert.assertTrue((String)("too many read complete events: " + clientReadCompletes.get()), (8202 > clientReadCompletes.get() ? 1 : 0) != 0);
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
        }
    }

    @Test
    public void testAutoCloseFalseDoesShutdownOutput() throws Throwable {
        this.run();
    }

    public void testAutoCloseFalseDoesShutdownOutput(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketHalfClosedTest.testAutoCloseFalseDoesShutdownOutput(false, false, sb, cb);
        SocketHalfClosedTest.testAutoCloseFalseDoesShutdownOutput(false, true, sb, cb);
        SocketHalfClosedTest.testAutoCloseFalseDoesShutdownOutput(true, false, sb, cb);
        SocketHalfClosedTest.testAutoCloseFalseDoesShutdownOutput(true, true, sb, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAutoCloseFalseDoesShutdownOutput(boolean allowHalfClosed, final boolean clientIsLeader, ServerBootstrap sb, Bootstrap cb) throws InterruptedException {
        int expectedBytes = 100;
        CountDownLatch serverReadExpectedLatch = new CountDownLatch(1);
        CountDownLatch doneLatch = new CountDownLatch(1);
        AtomicReference<Throwable> causeRef = new AtomicReference<Throwable>();
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            ((Bootstrap)((Bootstrap)cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)allowHalfClosed)).option(ChannelOption.AUTO_CLOSE, (Object)false)).option(ChannelOption.SO_LINGER, (Object)0);
            sb.childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)allowHalfClosed).childOption(ChannelOption.AUTO_CLOSE, (Object)false).childOption(ChannelOption.SO_LINGER, (Object)0);
            final AutoCloseFalseLeader leaderHandler = new AutoCloseFalseLeader(100, serverReadExpectedLatch, doneLatch, causeRef);
            final AutoCloseFalseFollower followerHandler = new AutoCloseFalseFollower(100, serverReadExpectedLatch, doneLatch, causeRef);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{clientIsLeader ? followerHandler : leaderHandler});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{clientIsLeader ? leaderHandler : followerHandler});
                }
            });
            serverChannel = sb.bind().sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            doneLatch.await();
            Assert.assertNull((Object)causeRef.get());
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
        }
    }

    @Test
    public void testAllDataReadClosure() throws Throwable {
        this.run();
    }

    public void testAllDataReadClosure(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketHalfClosedTest.testAllDataReadClosure(true, false, sb, cb);
        SocketHalfClosedTest.testAllDataReadClosure(true, true, sb, cb);
        SocketHalfClosedTest.testAllDataReadClosure(false, false, sb, cb);
        SocketHalfClosedTest.testAllDataReadClosure(false, true, sb, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAllDataReadClosure(final boolean autoRead, final boolean allowHalfClosed, ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int totalServerBytesWritten = 16384;
        int numReadsPerReadLoop = 2;
        final CountDownLatch serverInitializedLatch = new CountDownLatch(1);
        final CountDownLatch clientReadAllDataLatch = new CountDownLatch(1);
        final CountDownLatch clientHalfClosedLatch = new CountDownLatch(1);
        final AtomicInteger clientReadCompletes = new AtomicInteger();
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            ((Bootstrap)((Bootstrap)cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)allowHalfClosed)).option(ChannelOption.AUTO_READ, (Object)autoRead)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestNumReadsRecvByteBufAllocator(2));
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            ByteBuf buf = ctx.alloc().buffer(16384);
                            buf.writerIndex(buf.capacity());
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            serverInitializedLatch.countDown();
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int bytesRead;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            ByteBuf buf = (ByteBuf)msg;
                            this.bytesRead += buf.readableBytes();
                            buf.release();
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt == ChannelInputShutdownEvent.INSTANCE && allowHalfClosed) {
                                clientHalfClosedLatch.countDown();
                            } else if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                                ctx.close();
                            }
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            if (!allowHalfClosed) {
                                clientHalfClosedLatch.countDown();
                            }
                        }

                        public void channelReadComplete(ChannelHandlerContext ctx) {
                            clientReadCompletes.incrementAndGet();
                            if (this.bytesRead == 16384) {
                                clientReadAllDataLatch.countDown();
                            }
                            if (!autoRead) {
                                ctx.read();
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            clientChannel.read();
            serverInitializedLatch.await();
            clientReadAllDataLatch.await();
            clientHalfClosedLatch.await();
            Assert.assertTrue((String)("too many read complete events: " + clientReadCompletes.get()), (8202 > clientReadCompletes.get() ? 1 : 0) != 0);
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
        }
    }

    private static final class TestNumReadsRecvByteBufAllocator
    implements RecvByteBufAllocator {
        private final int numReads;

        TestNumReadsRecvByteBufAllocator(int numReads) {
            this.numReads = numReads;
        }

        public RecvByteBufAllocator.ExtendedHandle newHandle() {
            return new RecvByteBufAllocator.ExtendedHandle(){
                private int attemptedBytesRead;
                private int lastBytesRead;
                private int numMessagesRead;

                public ByteBuf allocate(ByteBufAllocator alloc) {
                    return alloc.ioBuffer(this.guess(), this.guess());
                }

                public int guess() {
                    return 1;
                }

                public void reset(ChannelConfig config) {
                    this.numMessagesRead = 0;
                }

                public void incMessagesRead(int numMessages) {
                    this.numMessagesRead += numMessages;
                }

                public void lastBytesRead(int bytes) {
                    this.lastBytesRead = bytes;
                }

                public int lastBytesRead() {
                    return this.lastBytesRead;
                }

                public void attemptedBytesRead(int bytes) {
                    this.attemptedBytesRead = bytes;
                }

                public int attemptedBytesRead() {
                    return this.attemptedBytesRead;
                }

                public boolean continueReading() {
                    return this.numMessagesRead < TestNumReadsRecvByteBufAllocator.this.numReads;
                }

                public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
                    return this.continueReading() && maybeMoreDataSupplier.get();
                }

                public void readComplete() {
                }
            };
        }
    }

    private static final class AutoCloseFalseLeader
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final int expectedBytes;
        private final CountDownLatch followerCloseLatch;
        private final CountDownLatch doneLatch;
        private final AtomicReference<Throwable> causeRef;
        private int bytesRead;
        private boolean seenOutputShutdown;

        AutoCloseFalseLeader(int expectedBytes, CountDownLatch followerCloseLatch, CountDownLatch doneLatch, AtomicReference<Throwable> causeRef) {
            this.expectedBytes = expectedBytes;
            this.followerCloseLatch = followerCloseLatch;
            this.doneLatch = doneLatch;
            this.causeRef = causeRef;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ByteBuf buf = ctx.alloc().buffer(this.expectedBytes);
            buf.writerIndex(buf.writerIndex() + this.expectedBytes);
            ctx.writeAndFlush((Object)buf.retainedDuplicate());
            this.followerCloseLatch.await();
            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.cause() == null) {
                        AutoCloseFalseLeader.this.causeRef.set(new IllegalStateException("second write should have failed!"));
                        AutoCloseFalseLeader.this.doneLatch.countDown();
                    }
                }
            });
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.bytesRead += msg.readableBytes();
            if (this.bytesRead >= this.expectedBytes) {
                if (!this.seenOutputShutdown) {
                    this.causeRef.set(new IllegalStateException(ChannelOutputShutdownEvent.class.getSimpleName() + " event was not seen"));
                }
                this.doneLatch.countDown();
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof ChannelOutputShutdownEvent) {
                this.seenOutputShutdown = true;
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.checkPrematureClose();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
            this.checkPrematureClose();
        }

        private void checkPrematureClose() {
            if (this.bytesRead < this.expectedBytes || !this.seenOutputShutdown) {
                this.causeRef.set(new IllegalStateException("leader premature close"));
                this.doneLatch.countDown();
            }
        }
    }

    private static final class AutoCloseFalseFollower
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final int expectedBytes;
        private final CountDownLatch followerCloseLatch;
        private final CountDownLatch doneLatch;
        private final AtomicReference<Throwable> causeRef;
        private int bytesRead;

        AutoCloseFalseFollower(int expectedBytes, CountDownLatch followerCloseLatch, CountDownLatch doneLatch, AtomicReference<Throwable> causeRef) {
            this.expectedBytes = expectedBytes;
            this.followerCloseLatch = followerCloseLatch;
            this.doneLatch = doneLatch;
            this.causeRef = causeRef;
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.checkPrematureClose();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
            this.checkPrematureClose();
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.bytesRead += msg.readableBytes();
            if (this.bytesRead >= this.expectedBytes) {
                ByteBuf buf = ctx.alloc().buffer(this.expectedBytes);
                buf.writerIndex(buf.writerIndex() + this.expectedBytes);
                ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        future.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                AutoCloseFalseFollower.this.followerCloseLatch.countDown();
                            }
                        });
                    }
                });
            }
        }

        private void checkPrematureClose() {
            if (this.bytesRead < this.expectedBytes) {
                this.causeRef.set(new IllegalStateException("follower premature close"));
                this.doneLatch.countDown();
            }
        }
    }
}

