/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.Assert;
import org.junit.Test;

public class SocketShutdownOutputBySelfTest
extends AbstractClientSocketTest {
    @Test(timeout=30000L)
    public void testShutdownOutput() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutput(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        SocketChannel ch = null;
        try {
            ss.bind(this.newSocketAddress());
            ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assert.assertTrue((boolean)ch.isActive());
            Assert.assertFalse((boolean)ch.isOutputShutdown());
            s = ss.accept();
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1})).sync();
            Assert.assertEquals((long)1L, (long)s.getInputStream().read());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertFalse((boolean)h.ch.isOutputShutdown());
            ch.shutdownOutput().sync();
            Assert.assertEquals((long)-1L, (long)s.getInputStream().read());
            Assert.assertTrue((boolean)h.ch.isOpen());
            Assert.assertTrue((boolean)h.ch.isActive());
            Assert.assertFalse((boolean)h.ch.isInputShutdown());
            Assert.assertTrue((boolean)h.ch.isOutputShutdown());
            s.getOutputStream().write(new byte[]{1});
            Assert.assertEquals((long)1L, (long)h.queue.take().byteValue());
        }
        finally {
            if (s != null) {
                s.close();
            }
            if (ch != null) {
                ch.close();
            }
            ss.close();
        }
    }

    @Test(timeout=30000L)
    public void testShutdownOutputAfterClosed() throws Throwable {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownOutputAfterClosed(Bootstrap cb) throws Throwable {
        TestHandler h = new TestHandler();
        ServerSocket ss = new ServerSocket();
        Socket s = null;
        try {
            ss.bind(this.newSocketAddress());
            SocketChannel ch = (SocketChannel)((Bootstrap)cb.handler((ChannelHandler)h)).connect(ss.getLocalSocketAddress()).sync().channel();
            Assert.assertTrue((boolean)ch.isActive());
            s = ss.accept();
            ch.close().syncUninterruptibly();
            try {
                ch.shutdownInput().syncUninterruptibly();
                Assert.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
            try {
                ch.shutdownOutput().syncUninterruptibly();
                Assert.fail();
            }
            catch (Throwable cause) {
                SocketShutdownOutputBySelfTest.checkThrowable(cause);
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            ss.close();
        }
    }

    private static void checkThrowable(Throwable cause) throws Throwable {
        if (!(cause instanceof ClosedChannelException) && !(cause instanceof SocketException)) {
            throw cause;
        }
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile SocketChannel ch;
        final BlockingQueue<Byte> queue = new LinkedBlockingQueue<Byte>();

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.ch = (SocketChannel)ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.queue.offer(msg.readByte());
        }
    }
}

