/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DatagramUnicastTest
extends AbstractDatagramTest {
    private static final byte[] BYTES = new byte[]{0, 1, 2, 3};

    @Test
    public void testSimpleSendDirectByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendHeapByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeDirectByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeHeapByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeMixedByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeMixedByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendWithoutBind() throws Throwable {
        this.run();
    }

    public void testSimpleSendWithoutBind(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 4);
    }

    private void testSimpleSend(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count) throws Throwable {
        for (WrapType type : WrapType.values()) {
            this.testSimpleSend0(sb, cb, buf.retain(), bindClient, bytes, count, type);
        }
        Assert.assertTrue((boolean)buf.release());
    }

    private void testSimpleSend0(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, final byte[] bytes, int count, WrapType wrapType) throws Throwable {
        Channel cc;
        final CountDownLatch latch = new CountDownLatch(count);
        sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

                    public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                        ByteBuf buf = (ByteBuf)msg.content();
                        Assert.assertEquals((long)bytes.length, (long)buf.readableBytes());
                        for (byte b : bytes) {
                            Assert.assertEquals((long)b, (long)buf.readByte());
                        }
                        latch.countDown();
                    }
                }});
            }
        });
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msgs) throws Exception {
            }
        });
        Channel sc = sb.bind(this.newSocketAddress()).sync().channel();
        if (bindClient) {
            cc = cb.bind(this.newSocketAddress()).sync().channel();
        } else {
            cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
            cc = cb.register().sync().channel();
        }
        InetSocketAddress addr = (InetSocketAddress)sc.localAddress();
        block6: for (int i = 0; i < count; ++i) {
            switch (wrapType) {
                case DUP: {
                    cc.write((Object)new DatagramPacket(buf.retain().duplicate(), addr));
                    continue block6;
                }
                case SLICE: {
                    cc.write((Object)new DatagramPacket(buf.retain().slice(), addr));
                    continue block6;
                }
                case READ_ONLY: {
                    cc.write((Object)new DatagramPacket(buf.retain().asReadOnly(), addr));
                    continue block6;
                }
                case NONE: {
                    cc.write((Object)new DatagramPacket(buf.retain(), addr));
                    continue block6;
                }
                default: {
                    throw new Error("unknown wrap type: " + (Object)((Object)wrapType));
                }
            }
        }
        buf.release();
        cc.flush();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        sc.close().sync();
        cc.close().sync();
    }

    private static enum WrapType {
        NONE,
        DUP,
        SLICE,
        READ_ONLY;

    }
}

