/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.UncheckedBooleanSupplier;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class SocketAutoReadTest
extends AbstractSocketTest {
    @Test
    public void testAutoReadOffDuringReadOnlyReadsOneTime() throws Throwable {
        this.run();
    }

    public void testAutoReadOffDuringReadOnlyReadsOneTime(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketAutoReadTest.testAutoReadOffDuringReadOnlyReadsOneTime(true, sb, cb);
        SocketAutoReadTest.testAutoReadOffDuringReadOnlyReadsOneTime(false, sb, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAutoReadOffDuringReadOnlyReadsOneTime(boolean readOutsideEventLoopThread, ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            AutoReadInitializer serverInitializer = new AutoReadInitializer(!readOutsideEventLoopThread);
            AutoReadInitializer clientInitializer = new AutoReadInitializer(!readOutsideEventLoopThread);
            ((ServerBootstrap)((ServerBootstrap)sb.option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.AUTO_READ, (Object)true)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestRecvByteBufAllocator()).childHandler((ChannelHandler)serverInitializer);
            serverChannel = sb.bind().syncUninterruptibly().channel();
            ((Bootstrap)((Bootstrap)cb.remoteAddress(serverChannel.localAddress()).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new TestRecvByteBufAllocator())).handler((ChannelHandler)clientInitializer);
            clientChannel = cb.connect().syncUninterruptibly().channel();
            clientChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[3]));
            serverInitializer.autoReadHandler.assertSingleRead();
            serverInitializer.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[3]));
            clientInitializer.autoReadHandler.assertSingleRead();
            if (readOutsideEventLoopThread) {
                serverInitializer.channel.read();
            }
            serverInitializer.autoReadHandler.assertSingleReadSecondTry();
            if (readOutsideEventLoopThread) {
                clientChannel.read();
            }
            clientInitializer.autoReadHandler.assertSingleReadSecondTry();
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().sync();
            }
            if (serverChannel != null) {
                serverChannel.close().sync();
            }
        }
    }

    private static final class TestRecvByteBufAllocator
    implements RecvByteBufAllocator {
        private TestRecvByteBufAllocator() {
        }

        public RecvByteBufAllocator.ExtendedHandle newHandle() {
            return new RecvByteBufAllocator.ExtendedHandle(){
                private ChannelConfig config;
                private int attemptedBytesRead;
                private int lastBytesRead;

                public ByteBuf allocate(ByteBufAllocator alloc) {
                    return alloc.ioBuffer(this.guess(), this.guess());
                }

                public int guess() {
                    return 1;
                }

                public void reset(ChannelConfig config) {
                    this.config = config;
                }

                public void incMessagesRead(int numMessages) {
                }

                public void lastBytesRead(int bytes) {
                    this.lastBytesRead = bytes;
                }

                public int lastBytesRead() {
                    return this.lastBytesRead;
                }

                public void attemptedBytesRead(int bytes) {
                    this.attemptedBytesRead = bytes;
                }

                public int attemptedBytesRead() {
                    return this.attemptedBytesRead;
                }

                public boolean continueReading() {
                    return this.config.isAutoRead();
                }

                public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
                    return this.config.isAutoRead();
                }

                public void readComplete() {
                }
            };
        }
    }

    private static final class AutoReadHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicInteger count = new AtomicInteger();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CountDownLatch latch2;
        private final boolean callRead;

        AutoReadHandler(boolean callRead) {
            this.callRead = callRead;
            this.latch2 = new CountDownLatch(callRead ? 3 : 2);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ReferenceCountUtil.release((Object)msg);
            if (this.count.incrementAndGet() == 1) {
                ctx.channel().config().setAutoRead(false);
            }
            if (this.callRead) {
                ctx.read();
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.latch.countDown();
            this.latch2.countDown();
        }

        void assertSingleRead() throws InterruptedException {
            Assert.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
            Assert.assertTrue((this.count.get() > 0 ? 1 : 0) != 0);
        }

        void assertSingleReadSecondTry() throws InterruptedException {
            Assert.assertTrue((boolean)this.latch2.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((long)(this.callRead ? 3L : 2L), (long)this.count.get());
        }
    }

    private static class AutoReadInitializer
    extends ChannelInitializer<Channel> {
        final AutoReadHandler autoReadHandler;
        volatile Channel channel;

        AutoReadInitializer(boolean readInEventLoop) {
            this.autoReadHandler = new AutoReadHandler(readInEventLoop);
        }

        protected void initChannel(Channel ch) throws Exception {
            this.channel = ch;
            ch.pipeline().addLast(new ChannelHandler[]{this.autoReadHandler});
        }
    }
}

