/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketFixedLengthEchoTest
extends AbstractSocketTest {
    private static final Random random = new Random();
    static final byte[] data = new byte[0x100000];

    @Test
    public void testFixedLengthEcho() throws Throwable {
        this.run();
    }

    @Test
    public void testFixedLengthEchoNotAutoRead() throws Throwable {
        this.run();
    }

    public void testFixedLengthEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFixedLengthEchoTest.testFixedLengthEcho(sb, cb, true);
    }

    public void testFixedLengthEchoNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFixedLengthEchoTest.testFixedLengthEcho(sb, cb, false);
    }

    private static void testFixedLengthEcho(ServerBootstrap sb, Bootstrap cb, boolean autoRead) throws Throwable {
        int length;
        final EchoHandler sh = new EchoHandler(autoRead);
        final EchoHandler ch = new EchoHandler(autoRead);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                sch.pipeline().addLast("decoder", (ChannelHandler)new FixedLengthFrameDecoder(1024));
                sch.pipeline().addAfter("decoder", "handler", (ChannelHandler)sh);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                sch.pipeline().addLast("decoder", (ChannelHandler)new FixedLengthFrameDecoder(1024));
                sch.pipeline().addAfter("decoder", "handler", (ChannelHandler)ch);
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        for (int i = 0; i < data.length; i += length) {
            length = Math.min(random.nextInt(3072), data.length - i);
            cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length));
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        EchoHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            Assert.assertEquals((long)1024L, (long)msg.readableBytes());
            byte[] actual = new byte[msg.readableBytes()];
            msg.getBytes(0, actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            if (this.channel.parent() != null) {
                this.channel.write((Object)msg.retain());
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

